/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.function.Supplier;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

@Documented(value=".Database Transaction Metrics")
public class TransactionMetrics
extends LifecycleAdapter {
    private static final String TRANSACTION_PREFIX = "neo4j.transaction";
    @Documented(value="The total number of started transactions")
    public static final String TX_STARTED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"started"});
    @Documented(value="The highest peak of concurrent transactions ever seen on this machine")
    public static final String TX_PEAK_CONCURRENT = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"peak_concurrent"});
    @Documented(value="The number of currently active transactions")
    public static final String TX_ACTIVE = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"active"});
    @Documented(value="The number of currently active read transactions")
    public static final String READ_TX_ACTIVE = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"active_read"});
    @Documented(value="The number of currently active write transactions")
    public static final String WRITE_TX_ACTIVE = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"active_write"});
    @Documented(value="The total number of committed transactions")
    public static final String TX_COMMITTED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"committed"});
    @Documented(value="The total number of committed read transactions")
    public static final String READ_TX_COMMITTED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"committed_read"});
    @Documented(value="The total number of committed write transactions")
    public static final String WRITE_TX_COMMITTED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"committed_write"});
    @Documented(value="The total number of rolled back transactions")
    public static final String TX_ROLLBACKS = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"rollbacks"});
    @Documented(value="The total number of rolled back read transactions")
    public static final String READ_TX_ROLLBACKS = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"rollbacks_read"});
    @Documented(value="The total number of rolled back write transactions")
    public static final String WRITE_TX_ROLLBACKS = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"rollbacks_write"});
    @Documented(value="The total number of terminated transactions")
    public static final String TX_TERMINATED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"terminated"});
    @Documented(value="The total number of terminated read transactions")
    public static final String READ_TX_TERMINATED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"terminated_read"});
    @Documented(value="The total number of terminated write transactions")
    public static final String WRITE_TX_TERMINATED = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"terminated_write"});
    @Documented(value="The ID of the last committed transaction")
    public static final String LAST_COMMITTED_TX_ID = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"last_committed_tx_id"});
    @Documented(value="The ID of the last closed transaction")
    public static final String LAST_CLOSED_TX_ID = MetricRegistry.name((String)"neo4j.transaction", (String[])new String[]{"last_closed_tx_id"});
    private final MetricRegistry registry;
    private final TransactionCounters transactionCounters;
    private final Supplier<TransactionIdStore> transactionIdStore;

    public TransactionMetrics(MetricRegistry registry, Supplier<TransactionIdStore> transactionIdStore, TransactionCounters transactionCounters) {
        this.registry = registry;
        this.transactionIdStore = transactionIdStore;
        this.transactionCounters = transactionCounters;
    }

    public void start() {
        this.registry.register(TX_STARTED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfStartedTransactions()));
        this.registry.register(TX_PEAK_CONCURRENT, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getPeakConcurrentNumberOfTransactions()));
        this.registry.register(TX_ACTIVE, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfActiveTransactions()));
        this.registry.register(READ_TX_ACTIVE, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfActiveReadTransactions()));
        this.registry.register(WRITE_TX_ACTIVE, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfActiveWriteTransactions()));
        this.registry.register(TX_COMMITTED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfCommittedTransactions()));
        this.registry.register(READ_TX_COMMITTED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfCommittedReadTransactions()));
        this.registry.register(WRITE_TX_COMMITTED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfCommittedWriteTransactions()));
        this.registry.register(TX_ROLLBACKS, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfRolledBackTransactions()));
        this.registry.register(READ_TX_ROLLBACKS, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfRolledBackReadTransactions()));
        this.registry.register(WRITE_TX_ROLLBACKS, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfRolledBackWriteTransactions()));
        this.registry.register(TX_TERMINATED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfTerminatedTransactions()));
        this.registry.register(READ_TX_TERMINATED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfTerminatedReadTransactions()));
        this.registry.register(WRITE_TX_TERMINATED, (Metric)((Gauge)() -> ((TransactionCounters)this.transactionCounters).getNumberOfTerminatedWriteTransactions()));
        this.registry.register(LAST_COMMITTED_TX_ID, (Metric)((Gauge)() -> this.transactionIdStore.get().getLastCommittedTransactionId()));
        this.registry.register(LAST_CLOSED_TX_ID, (Metric)((Gauge)() -> this.transactionIdStore.get().getLastClosedTransactionId()));
    }

    public void stop() {
        this.registry.remove(TX_STARTED);
        this.registry.remove(TX_PEAK_CONCURRENT);
        this.registry.remove(TX_ACTIVE);
        this.registry.remove(READ_TX_ACTIVE);
        this.registry.remove(WRITE_TX_ACTIVE);
        this.registry.remove(TX_COMMITTED);
        this.registry.remove(READ_TX_COMMITTED);
        this.registry.remove(WRITE_TX_COMMITTED);
        this.registry.remove(TX_ROLLBACKS);
        this.registry.remove(READ_TX_ROLLBACKS);
        this.registry.remove(WRITE_TX_ROLLBACKS);
        this.registry.remove(TX_TERMINATED);
        this.registry.remove(READ_TX_TERMINATED);
        this.registry.remove(WRITE_TX_TERMINATED);
        this.registry.remove(LAST_COMMITTED_TX_ID);
        this.registry.remove(LAST_CLOSED_TX_ID);
    }
}

