/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.query.QueryLogFormatter;
import org.neo4j.kernel.impl.query.QueryLogger;
import org.neo4j.logging.Log;

class ConfiguredQueryLogger
implements QueryLogger {
    private final Log log;
    private final long thresholdMillis;
    private final boolean logQueryParameters;
    private final boolean logDetailedTime;
    private final boolean logAllocatedBytes;
    private final boolean logPageDetails;
    private final boolean logRuntime;
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(?:(?i)call)\\s+dbms(?:\\.security)?\\.change(?:User)?Password\\((?:\\s*(?:'(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|[^,]*)\\s*,)?\\s*('(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|\\$\\w*|\\{\\w*})\\s*\\)");

    ConfiguredQueryLogger(Log log, Config config) {
        this.log = log;
        this.thresholdMillis = ((Duration)config.get(GraphDatabaseSettings.log_queries_threshold)).toMillis();
        this.logQueryParameters = (Boolean)config.get(GraphDatabaseSettings.log_queries_parameter_logging_enabled);
        this.logDetailedTime = (Boolean)config.get(GraphDatabaseSettings.log_queries_detailed_time_logging_enabled);
        this.logAllocatedBytes = (Boolean)config.get(GraphDatabaseSettings.log_queries_allocation_logging_enabled);
        this.logPageDetails = (Boolean)config.get(GraphDatabaseSettings.log_queries_page_detail_logging_enabled);
        this.logRuntime = (Boolean)config.get(GraphDatabaseSettings.log_queries_runtime_logging_enabled);
    }

    @Override
    public void failure(ExecutingQuery query, Throwable failure) {
        this.log.error(this.logEntry(query.snapshot()), failure);
    }

    @Override
    public void success(ExecutingQuery query) {
        if (TimeUnit.NANOSECONDS.toMillis(query.elapsedNanos()) >= this.thresholdMillis) {
            QuerySnapshot snapshot = query.snapshot();
            this.log.info(this.logEntry(snapshot));
        }
    }

    private String logEntry(QuerySnapshot query) {
        String sourceString = query.clientConnection().asConnectionDetails();
        String queryText = query.queryText();
        HashSet<String> passwordParams = new HashSet<String>();
        Matcher matcher = PASSWORD_PATTERN.matcher(queryText);
        while (matcher.find()) {
            String password = matcher.group(1).trim();
            if (password.charAt(0) == '$') {
                passwordParams.add(password.substring(1));
                continue;
            }
            if (password.charAt(0) == '{') {
                passwordParams.add(password.substring(1, password.length() - 1));
                continue;
            }
            queryText = queryText.replace(password, "******");
        }
        StringBuilder result = new StringBuilder();
        result.append(query.elapsedTimeMillis()).append(" ms: ");
        if (this.logDetailedTime) {
            QueryLogFormatter.formatDetailedTime(result, query);
        }
        if (this.logAllocatedBytes) {
            QueryLogFormatter.formatAllocatedBytes(result, query);
        }
        if (this.logPageDetails) {
            QueryLogFormatter.formatPageDetails(result, query);
        }
        result.append(sourceString).append(" - ").append(queryText);
        if (this.logQueryParameters) {
            QueryLogFormatter.formatMapValue(result.append(" - "), query.queryParameters(), passwordParams);
        }
        if (this.logRuntime) {
            result.append(" - runtime=").append(query.runtime());
        }
        QueryLogFormatter.formatMap(result.append(" - "), query.transactionAnnotationData());
        return result.toString();
    }
}

