/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.authz.AuthorizationInfo;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.enterprise.api.security.EnterpriseLoginContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;

class StandardEnterpriseLoginContext
implements EnterpriseLoginContext {
    private static final String SCHEMA_READ_WRITE = "schema:read,write";
    private static final String TOKEN_CREATE = "token:create";
    private static final String READ_WRITE = "data:read,write";
    private static final String READ = "data:read";
    private final MultiRealmAuthManager authManager;
    private final ShiroSubject shiroSubject;
    private final NeoShiroSubject neoShiroSubject;

    StandardEnterpriseLoginContext(MultiRealmAuthManager authManager, ShiroSubject shiroSubject) {
        this.authManager = authManager;
        this.shiroSubject = shiroSubject;
        this.neoShiroSubject = new NeoShiroSubject();
    }

    private boolean isAdmin() {
        return this.shiroSubject.isAuthenticated() && this.shiroSubject.isPermitted("*");
    }

    public AuthSubject subject() {
        return this.neoShiroSubject;
    }

    private StandardAccessMode mode(Function<String, Integer> tokenLookup) {
        boolean isAuthenticated = this.shiroSubject.isAuthenticated();
        return new StandardAccessMode(isAuthenticated && this.shiroSubject.isPermitted(READ), isAuthenticated && this.shiroSubject.isPermitted(READ_WRITE), isAuthenticated && this.shiroSubject.isPermitted(TOKEN_CREATE), isAuthenticated && this.shiroSubject.isPermitted(SCHEMA_READ_WRITE), this.shiroSubject.getAuthenticationResult() == AuthenticationResult.PASSWORD_CHANGE_REQUIRED, this.queryForRoleNames(), this.queryForPropertyPermissions(tokenLookup));
    }

    public EnterpriseSecurityContext authorize(Function<String, Integer> propertyIdLookup) {
        StandardAccessMode mode = this.mode(propertyIdLookup);
        return new EnterpriseSecurityContext((AuthSubject)this.neoShiroSubject, (AccessMode)mode, mode.roles, this.isAdmin());
    }

    public Set<String> roles() {
        return this.queryForRoleNames();
    }

    private Set<String> queryForRoleNames() {
        Collection<AuthorizationInfo> authorizationInfo = this.authManager.getAuthorizationInfo(this.shiroSubject.getPrincipals());
        return authorizationInfo.stream().flatMap(authInfo -> {
            Collection roles = authInfo.getRoles();
            return roles == null ? Stream.empty() : roles.stream();
        }).collect(Collectors.toSet());
    }

    private IntPredicate queryForPropertyPermissions(Function<String, Integer> tokenLookup) {
        return this.authManager.getPropertyPermissions(this.roles(), tokenLookup);
    }

    private static String buildMessageFromThrowables(String baseMessage, List<Throwable> throwables) {
        if (throwables == null) {
            return baseMessage;
        }
        StringBuilder sb = new StringBuilder(baseMessage);
        for (Throwable t : throwables) {
            Throwable causeCause;
            Throwable cause;
            if (t.getMessage() != null) {
                sb.append(" (");
                sb.append(t.getMessage());
                sb.append(")");
            }
            if ((cause = t.getCause()) != null && cause.getMessage() != null) {
                sb.append(" (");
                sb.append(cause.getMessage());
                sb.append(")");
            }
            if ((causeCause = cause != null ? cause.getCause() : null) == null || causeCause.getMessage() == null) continue;
            sb.append(" (");
            sb.append(causeCause.getMessage());
            sb.append(")");
        }
        return sb.toString();
    }

    class NeoShiroSubject
    implements AuthSubject {
        NeoShiroSubject() {
        }

        public String username() {
            Object principal = StandardEnterpriseLoginContext.this.shiroSubject.getPrincipal();
            if (principal != null) {
                return principal.toString();
            }
            return "";
        }

        public void logout() {
            StandardEnterpriseLoginContext.this.shiroSubject.logout();
        }

        public AuthenticationResult getAuthenticationResult() {
            return StandardEnterpriseLoginContext.this.shiroSubject.getAuthenticationResult();
        }

        public void setPasswordChangeNoLongerRequired() {
            if (this.getAuthenticationResult() == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
                StandardEnterpriseLoginContext.this.shiroSubject.setAuthenticationResult(AuthenticationResult.SUCCESS);
            }
        }

        public boolean hasUsername(String username) {
            Object principal = StandardEnterpriseLoginContext.this.shiroSubject.getPrincipal();
            return principal != null && username != null && username.equals(principal);
        }

        public String getAuthenticationFailureMessage() {
            String message = "";
            List<Throwable> throwables = StandardEnterpriseLoginContext.this.shiroSubject.getAuthenticationInfo().getThrowables();
            switch (StandardEnterpriseLoginContext.this.shiroSubject.getAuthenticationResult()) {
                case FAILURE: {
                    message = StandardEnterpriseLoginContext.buildMessageFromThrowables("invalid principal or credentials", throwables);
                    break;
                }
                case TOO_MANY_ATTEMPTS: {
                    message = StandardEnterpriseLoginContext.buildMessageFromThrowables("too many failed attempts", throwables);
                    break;
                }
                case PASSWORD_CHANGE_REQUIRED: {
                    message = StandardEnterpriseLoginContext.buildMessageFromThrowables("password change required", throwables);
                    break;
                }
            }
            return message;
        }

        public void clearAuthenticationInfo() {
            StandardEnterpriseLoginContext.this.shiroSubject.clearAuthenticationInfo();
        }
    }

    private static class StandardAccessMode
    implements AccessMode {
        private final boolean allowsReads;
        private final boolean allowsWrites;
        private final boolean allowsSchemaWrites;
        private final boolean allowsTokenCreates;
        private final boolean passwordChangeRequired;
        private final Set<String> roles;
        private final IntPredicate propertyPermissions;

        StandardAccessMode(boolean allowsReads, boolean allowsWrites, boolean allowsTokenCreates, boolean allowsSchemaWrites, boolean passwordChangeRequired, Set<String> roles, IntPredicate propertyPermissions) {
            this.allowsReads = allowsReads;
            this.allowsWrites = allowsWrites;
            this.allowsTokenCreates = allowsTokenCreates;
            this.allowsSchemaWrites = allowsSchemaWrites;
            this.passwordChangeRequired = passwordChangeRequired;
            this.roles = roles;
            this.propertyPermissions = propertyPermissions;
        }

        public boolean allowsReads() {
            return this.allowsReads;
        }

        public boolean allowsWrites() {
            return this.allowsWrites;
        }

        public boolean allowsTokenCreates() {
            return this.allowsTokenCreates;
        }

        public boolean allowsSchemaWrites() {
            return this.allowsSchemaWrites;
        }

        public boolean allowsPropertyReads(int propertyKey) {
            return this.propertyPermissions.test(propertyKey);
        }

        public boolean allowsProcedureWith(String[] roleNames) {
            for (String roleName : roleNames) {
                if (!this.roles.contains(roleName)) continue;
                return true;
            }
            return false;
        }

        public AuthorizationViolationException onViolation(String msg) {
            if (this.passwordChangeRequired) {
                return AccessMode.Static.CREDENTIALS_EXPIRED.onViolation(msg);
            }
            return new AuthorizationViolationException(msg);
        }

        public String name() {
            TreeSet<String> sortedRoles = new TreeSet<String>(this.roles);
            return this.roles.isEmpty() ? "no roles" : "roles [" + String.join((CharSequence)",", sortedRoles) + "]";
        }
    }
}

