/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.util.Map;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthToken;

public class PluginApiAuthToken
implements AuthToken {
    private final String principal;
    private final char[] credentials;
    private final Map<String, Object> parameters;

    private PluginApiAuthToken(String principal, char[] credentials, Map<String, Object> parameters) {
        this.principal = principal;
        this.credentials = credentials;
        this.parameters = parameters;
    }

    public String principal() {
        return this.principal;
    }

    public char[] credentials() {
        return this.credentials;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public static AuthToken of(String principal, char[] credentials, Map<String, Object> parameters) {
        return new PluginApiAuthToken(principal, credentials, parameters);
    }

    public static AuthToken createFromMap(Map<String, Object> authTokenMap) throws InvalidAuthTokenException {
        String scheme = org.neo4j.kernel.api.security.AuthToken.safeCast((String)"scheme", authTokenMap);
        String principal = org.neo4j.kernel.api.security.AuthToken.safeCast((String)"principal", authTokenMap);
        String credentials = null;
        if (scheme.equals("basic")) {
            credentials = org.neo4j.kernel.api.security.AuthToken.safeCast((String)"credentials", authTokenMap);
        } else {
            Object credentialsObject = authTokenMap.get("credentials");
            if (credentialsObject instanceof String) {
                credentials = (String)credentialsObject;
            }
        }
        Map parameters = org.neo4j.kernel.api.security.AuthToken.safeCastMap((String)"parameters", authTokenMap);
        return PluginApiAuthToken.of(principal, credentials != null ? credentials.toCharArray() : null, parameters);
    }
}

