/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.handler;

import java.lang.reflect.Field;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.Parameter;
import org.ocpsoft.rewrite.annotation.api.FieldContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.FieldAnnotationHandler;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Or;
import org.ocpsoft.rewrite.config.True;
import org.ocpsoft.rewrite.el.El;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.ParameterBuilder;
import org.ocpsoft.rewrite.servlet.config.RequestParameter;

public class ParameterHandler
extends FieldAnnotationHandler<Parameter> {
    private final Logger log = Logger.getLogger(ParameterHandler.class);

    @Override
    public Class<Parameter> handles() {
        return Parameter.class;
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public void process(FieldContext context, Parameter annotation, HandlerChain chain) {
        Field field = context.getJavaField();
        String param = field.getName();
        if (!annotation.value().isEmpty()) {
            param = annotation.value().trim();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Binding parameter [{}] to field [{}]", param, field);
        }
        RequestParameter requestParameter = RequestParameter.matches(param, "{" + param + "}");
        ConditionBuilder composite = context.getRuleBuilder().getConditionBuilder().and(Or.any(requestParameter, new True()));
        context.getRuleBuilder().when(composite);
        ConfigurableParameter<?> parameterBuilder = context.getRuleBuilder().where(param);
        El binding = El.property(context.getJavaClass(), field.getName());
        context.put(Binding.class, binding);
        context.put(ParameterBuilder.class, parameterBuilder);
        context.put(org.ocpsoft.rewrite.param.Parameter.class, parameterBuilder);
        chain.proceed();
        Binding enrichedBinding = (Binding)context.get(Binding.class);
        Assert.notNull(enrichedBinding, "Binding was removed from the context");
        parameterBuilder.bindsTo(enrichedBinding);
    }
}

