/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ocpsoft.rewrite.config.CompositeCondition;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Conditions;
import org.ocpsoft.rewrite.config.DefaultConditionBuilder;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.Operations;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.RelocatableRule;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.True;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedRule;
import org.ocpsoft.rewrite.util.Visitor;

public class RuleBuilder
implements ParameterizedRule,
RelocatableRule,
CompositeCondition,
CompositeOperation {
    private final ParameterStore store;
    private Integer priority = null;
    private String id = "";
    private Condition condition = new True();
    private Operation operation;

    private RuleBuilder() {
        this.store = new DefaultParameterStore();
    }

    private RuleBuilder(Rule rule) {
        this.store = rule instanceof RuleBuilder ? ((RuleBuilder)rule).getParameterStore() : new DefaultParameterStore();
        this.withId(rule.getId()).when(rule).perform(rule);
    }

    public static RuleBuilder define() {
        return new RuleBuilder();
    }

    public static RuleBuilder wrap(Rule rule) {
        return new RuleBuilder(rule);
    }

    public static RuleBuilder define(String id) {
        return RuleBuilder.define().withId(id);
    }

    public RuleBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public RuleBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public RuleBuilder when(Condition condition) {
        this.condition = Conditions.wrap(this.condition).and(condition);
        return this;
    }

    public RuleBuilder perform(Operation operation) {
        this.operation = Operations.wrap(this.operation).and(operation);
        return this;
    }

    @Override
    public boolean evaluate(Rewrite event, EvaluationContext context) {
        context.put(ParameterStore.class, this.store);
        return this.condition == null || this.condition.evaluate(event, context);
    }

    @Override
    public void perform(Rewrite event, EvaluationContext context) {
        if (this.operation != null) {
            this.operation.perform(event, context);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int priority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Override
    public boolean isRelocated() {
        return this.priority != null;
    }

    public DefaultConditionBuilder getConditionBuilder() {
        if (this.condition == null) {
            this.condition = Conditions.create();
        } else if (!(this.condition instanceof DefaultConditionBuilder)) {
            this.condition = Conditions.wrap(this.condition);
        }
        return (DefaultConditionBuilder)this.condition;
    }

    public DefaultOperationBuilder getOperationBuilder() {
        if (this.operation == null) {
            this.operation = Operations.create();
        } else if (!(this.operation instanceof DefaultOperationBuilder)) {
            this.operation = Operations.wrap(this.operation);
        }
        return (DefaultOperationBuilder)this.operation;
    }

    public void accept(Visitor<Condition> visitor) {
        new ConditionVisit(this.condition).accept(visitor);
    }

    public String toString() {
        return "RuleBuilder [priority=" + this.priority + ", id=" + this.id + ", condition=" + this.condition + ", operation=" + this.operation + "]";
    }

    @Override
    public List<Operation> getOperations() {
        if (this.operation instanceof CompositeOperation) {
            return ((CompositeOperation)this.operation).getOperations();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Condition> getConditions() {
        if (this.condition instanceof CompositeCondition) {
            return ((CompositeCondition)this.condition).getConditions();
        }
        return Collections.emptyList();
    }

    @Override
    public ParameterStore getParameterStore() {
        return this.store;
    }

    public ConfigurableParameter<?> where(String name) {
        this.assertParameterExists(name);
        Parameter<?> result = this.getParameterStore().get(name, new DefaultParameter(name));
        if (result instanceof ConfigurableParameter) {
            return (ConfigurableParameter)result;
        }
        throw new RewriteException("Cannot configure read-only parameter [" + name + "].");
    }

    private void assertParameterExists(String name) {
        final LinkedHashSet parameterNames = new LinkedHashSet();
        ParameterizedCallback callback = new ParameterizedCallback(){

            @Override
            public void call(Parameterized parameterized) {
                Set<String> names = parameterized.getRequiredParameterNames();
                parameterNames.addAll(names);
            }
        };
        ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor(callback);
        new ConditionVisit(this).accept(conditionVisitor);
        ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor(callback);
        new OperationVisit(this).accept(operationVisitor);
        if (!parameterNames.contains(name)) {
            throw new IllegalArgumentException("Parameter [" + name + "] does not exist in rule [" + this + "] and cannot be configured.");
        }
    }
}

