/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v103.page.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v103.page.model.AdFrameExplanation;
import org.openqa.selenium.devtools.v103.page.model.AdFrameType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AdFrameStatus {
    private final AdFrameType adFrameType;
    private final Optional<List<AdFrameExplanation>> explanations;

    public AdFrameStatus(AdFrameType adFrameType, Optional<List<AdFrameExplanation>> explanations) {
        this.adFrameType = Objects.requireNonNull(adFrameType, "adFrameType is required");
        this.explanations = explanations;
    }

    public AdFrameType getAdFrameType() {
        return this.adFrameType;
    }

    public Optional<List<AdFrameExplanation>> getExplanations() {
        return this.explanations;
    }

    private static AdFrameStatus fromJson(JsonInput input) {
        AdFrameType adFrameType = null;
        Optional<List<AdFrameExplanation>> explanations = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "adFrameType": {
                    adFrameType = (AdFrameType)((Object)input.read(AdFrameType.class));
                    continue block8;
                }
                case "explanations": {
                    explanations = Optional.ofNullable((List)input.read(new TypeToken<List<AdFrameExplanation>>(){}.getType()));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AdFrameStatus(adFrameType, explanations);
    }
}

