/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache.redis;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.redis.ExpireVo;
import org.tio.utils.cache.redis.RedisCache;
import org.tio.utils.lock.SetWithLock;

public class RedisTask {
    private static Logger log = LoggerFactory.getLogger(RedisTask.class);
    private static boolean started = false;
    private static Set<ExpireVo> set = new HashSet<ExpireVo>();
    private static SetWithLock<ExpireVo> setWithLock = new SetWithLock<ExpireVo>(set);

    public static void add(String cacheName, String key, long expire) {
        ExpireVo expireVo = new ExpireVo(cacheName, key, expire);
        setWithLock.add(expireVo);
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (started) {
            return;
        }
        Class<RedisTask> clazz = RedisTask.class;
        synchronized (RedisTask.class) {
            if (started) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            started = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        ReentrantReadWriteLock.WriteLock writeLock = setWithLock.getLock().writeLock();
                        writeLock.lock();
                        try {
                            Set set = (Set)setWithLock.getObj();
                            for (ExpireVo expireVo : set) {
                                log.info("\u66f4\u65b0\u7f13\u5b58\u8fc7\u671f\u65f6\u95f4, cacheName:{}, key:{}, expire:{}", new Object[]{expireVo.getCacheName(), expireVo.getKey(), expireVo.getExpire()});
                                RedisCache.getCache(expireVo.getCacheName()).getBucket(expireVo.getKey()).expire(expireVo.getExpire(), TimeUnit.SECONDS);
                            }
                            set.clear();
                            continue;
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        finally {
                            writeLock.unlock();
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                log.error(e.toString(), (Throwable)e);
                            }
                            continue;
                        }
                        break;
                    }
                }
            }, RedisTask.class.getName()).start();
            return;
        }
    }

    private RedisTask() {
    }
}

