/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.ssl;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class SSLEngineSimpleDemoOracle {
    private static boolean logging = true;
    private static boolean debug = false;
    private SSLContext sslc;
    private SSLEngine clientEngine;
    private ByteBuffer clientOut;
    private ByteBuffer clientIn;
    private SSLEngine serverEngine;
    private ByteBuffer serverOut;
    private ByteBuffer serverIn;
    private ByteBuffer cTOs;
    private ByteBuffer sTOc;
    private static String keyStoreFile = "D:/tool/tio-ca/214323428310224.jks";
    private static String trustStoreFile = "D:/tool/tio-ca/214323428310224.jks";
    private static String passwd = "214323428310224";
    private static boolean resultOnce = true;

    public static void main(String[] args) throws Exception {
        if (debug) {
            System.setProperty("javax.net.debug", "all");
        }
        SSLEngineSimpleDemoOracle demo = new SSLEngineSimpleDemoOracle();
        demo.runDemo();
        System.out.println("Demo Completed.");
    }

    public SSLEngineSimpleDemoOracle() throws Exception {
        KeyStore ks = KeyStore.getInstance("jks");
        KeyStore ts = KeyStore.getInstance("jks");
        char[] passphrase = passwd.toCharArray();
        ks.load(new FileInputStream(keyStoreFile), passphrase);
        ts.load(new FileInputStream(trustStoreFile), passphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, passphrase);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ts);
        SSLContext sslCtx = SSLContext.getInstance("TLS");
        sslCtx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        this.sslc = sslCtx;
    }

    private void createSSLEngines() throws Exception {
        this.serverEngine = this.sslc.createSSLEngine();
        this.serverEngine.setUseClientMode(false);
        this.serverEngine.setNeedClientAuth(false);
        this.clientEngine = this.sslc.createSSLEngine("client", 80);
        this.clientEngine.setUseClientMode(true);
    }

    private void runDemo() throws Exception {
        boolean dataDone = false;
        this.createSSLEngines();
        this.createBuffers();
        while (!SSLEngineSimpleDemoOracle.isEngineClosed(this.clientEngine) || !SSLEngineSimpleDemoOracle.isEngineClosed(this.serverEngine)) {
            SSLEngineSimpleDemoOracle.log("================");
            SSLEngineResult clientResult = this.clientEngine.wrap(this.clientOut, this.cTOs);
            SSLEngineSimpleDemoOracle.log("client wrap: ", clientResult);
            SSLEngineSimpleDemoOracle.runDelegatedTasks(clientResult, this.clientEngine);
            SSLEngineResult serverResult = this.serverEngine.wrap(this.serverOut, this.sTOc);
            SSLEngineSimpleDemoOracle.log("server wrap: ", serverResult);
            SSLEngineSimpleDemoOracle.runDelegatedTasks(serverResult, this.serverEngine);
            this.cTOs.flip();
            this.sTOc.flip();
            SSLEngineSimpleDemoOracle.log("----");
            clientResult = this.clientEngine.unwrap(this.sTOc, this.clientIn);
            SSLEngineSimpleDemoOracle.log("client unwrap: ", clientResult);
            SSLEngineSimpleDemoOracle.runDelegatedTasks(clientResult, this.clientEngine);
            serverResult = this.serverEngine.unwrap(this.cTOs, this.serverIn);
            SSLEngineSimpleDemoOracle.log("server unwrap: ", serverResult);
            SSLEngineSimpleDemoOracle.runDelegatedTasks(serverResult, this.serverEngine);
            this.cTOs.compact();
            this.sTOc.compact();
            if (dataDone || this.clientOut.limit() != this.serverIn.position() || this.serverOut.limit() != this.clientIn.position()) continue;
            SSLEngineSimpleDemoOracle.checkTransfer(this.serverOut, this.clientIn);
            SSLEngineSimpleDemoOracle.checkTransfer(this.clientOut, this.serverIn);
            SSLEngineSimpleDemoOracle.log("\tClosing clientEngine's *OUTBOUND*...");
            this.clientEngine.closeOutbound();
            dataDone = true;
        }
    }

    private void createBuffers() {
        SSLSession session = this.clientEngine.getSession();
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        this.clientIn = ByteBuffer.allocate(appBufferMax + 50);
        this.serverIn = ByteBuffer.allocate(appBufferMax + 50);
        this.cTOs = ByteBuffer.allocateDirect(netBufferMax);
        this.sTOc = ByteBuffer.allocateDirect(netBufferMax);
        this.clientOut = ByteBuffer.wrap("Hi Server, I'm Client".getBytes());
        this.serverOut = ByteBuffer.wrap("Hello Client, I'm Server".getBytes());
    }

    private static void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) throws Exception {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = engine.getDelegatedTask()) != null) {
                SSLEngineSimpleDemoOracle.log("\trunning delegated task...");
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = engine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new Exception("handshake shouldn't need additional tasks");
            }
            SSLEngineSimpleDemoOracle.log("\tnew HandshakeStatus: " + (Object)((Object)hsStatus));
        }
    }

    private static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    private static void checkTransfer(ByteBuffer a, ByteBuffer b) throws Exception {
        a.flip();
        b.flip();
        if (!a.equals(b)) {
            throw new Exception("Data didn't transfer cleanly");
        }
        SSLEngineSimpleDemoOracle.log("\tData transferred cleanly");
        a.position(a.limit());
        b.position(b.limit());
        a.limit(a.capacity());
        b.limit(b.capacity());
    }

    private static void log(String str, SSLEngineResult result) {
        if (!logging) {
            return;
        }
        if (resultOnce) {
            resultOnce = false;
            System.out.println("The format of the SSLEngineResult is: \n\t\"getStatus() / getHandshakeStatus()\" +\n\t\"bytesConsumed() / bytesProduced()\"\n");
        }
        SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
        SSLEngineSimpleDemoOracle.log(str + (Object)((Object)result.getStatus()) + "/" + (Object)((Object)hsStatus) + ", " + result.bytesConsumed() + "/" + result.bytesProduced() + " bytes");
        if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            SSLEngineSimpleDemoOracle.log("\t...ready for application data");
        }
    }

    private static void log(String str) {
        if (logging) {
            System.out.println(str);
        }
    }
}

