/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache.guava;

import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.ICache;
import org.tio.utils.guava.GuavaUtils;

public class GuavaCache
implements ICache {
    private static Logger log = LoggerFactory.getLogger(GuavaCache.class);
    public static Map<String, GuavaCache> map = new HashMap<String, GuavaCache>();
    private LoadingCache<String, Serializable> loadingCache = null;
    private LoadingCache<String, Serializable> temporaryLoadingCache = null;

    public static GuavaCache getCache(String cacheName) {
        GuavaCache guavaCache = map.get(cacheName);
        if (guavaCache == null) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)GuavaCache.class.getSimpleName());
        }
        return guavaCache;
    }

    public static GuavaCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        GuavaCache guavaCache = GuavaCache.register(cacheName, timeToLiveSeconds, timeToIdleSeconds, null);
        return guavaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GuavaCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListener<String, Serializable> removalListener) {
        GuavaCache guavaCache = map.get(cacheName);
        if (guavaCache != null) return guavaCache;
        Class<GuavaCache> clazz = GuavaCache.class;
        synchronized (GuavaCache.class) {
            guavaCache = map.get(cacheName);
            if (guavaCache != null) return guavaCache;
            Integer concurrencyLevel = 8;
            Integer initialCapacity = 10;
            Integer maximumSize = 5000000;
            boolean recordStats = false;
            LoadingCache<String, Serializable> loadingCache = GuavaUtils.createLoadingCache(concurrencyLevel, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, removalListener);
            Integer temporaryMaximumSize = 500000;
            LoadingCache<String, Serializable> temporaryLoadingCache = GuavaUtils.createLoadingCache(concurrencyLevel, 10L, null, initialCapacity, temporaryMaximumSize, recordStats, removalListener);
            guavaCache = new GuavaCache(loadingCache, temporaryLoadingCache);
            map.put(cacheName, guavaCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return guavaCache;
        }
    }

    private GuavaCache(LoadingCache<String, Serializable> loadingCache, LoadingCache<String, Serializable> temporaryLoadingCache) {
        this.loadingCache = loadingCache;
        this.temporaryLoadingCache = temporaryLoadingCache;
    }

    @Override
    public void clear() {
        this.loadingCache.invalidateAll();
        this.temporaryLoadingCache.invalidateAll();
    }

    @Override
    public Serializable get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Serializable ret = (Serializable)this.loadingCache.getIfPresent((Object)key);
        if (ret == null) {
            ret = (Serializable)this.temporaryLoadingCache.getIfPresent((Object)key);
        }
        return ret;
    }

    public Collection<String> keys() {
        ConcurrentMap map = this.loadingCache.asMap();
        return map.keySet();
    }

    @Override
    public void put(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.loadingCache.put((Object)key, (Object)value);
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.temporaryLoadingCache.put((Object)key, (Object)value);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.loadingCache.invalidate((Object)key);
        this.temporaryLoadingCache.invalidate((Object)key);
    }

    public ConcurrentMap<String, Serializable> asMap() {
        return this.loadingCache.asMap();
    }

    public long size() {
        return this.loadingCache.size();
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key);
    }

    @Override
    public long ttl(String key) {
        throw new RuntimeException("\u4e0d\u652f\u6301ttl");
    }
}

