/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.convert.Converter;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.page.Page;

public class PageUtils {
    private static Logger log = LoggerFactory.getLogger(PageUtils.class);

    public static <T> Page<T> fromList(List<T> list, int pageNumber, int pageSize) {
        return PageUtils.fromList(list, pageNumber, pageSize, null);
    }

    public static <T> Page<T> fromList(List<?> list, int pageNumber, int pageSize, Converter<T> converter) {
        if (list == null) {
            return null;
        }
        Page<Object> page = PageUtils.pre(list, pageNumber, pageSize);
        List<Object> pageData = page.getList();
        if (pageData == null) {
            return page;
        }
        int startIndex = Math.min((page.getPageNumber() - 1) * page.getPageSize(), list.size());
        int endIndex = Math.min(page.getPageNumber() * page.getPageSize(), list.size());
        for (int i = startIndex; i < endIndex; ++i) {
            if (converter != null) {
                pageData.add(converter.convert(list.get(i)));
                continue;
            }
            pageData.add(list.get(i));
        }
        page.setList(pageData);
        return page;
    }

    public static <T> Page<T> fromSet(Set<T> set, int pageNumber, int pageSize) {
        return PageUtils.fromSet(set, pageNumber, pageSize, null);
    }

    public static <T> Page<T> fromSet(Set<?> set, int pageNumber, int pageSize, Converter<T> converter) {
        if (set == null) {
            return null;
        }
        Page<Object> page = PageUtils.pre(set, pageNumber, pageSize);
        List<Object> pageData = page.getList();
        if (pageData == null) {
            return page;
        }
        int startIndex = Math.min((page.getPageNumber() - 1) * page.getPageSize(), set.size());
        int endIndex = Math.min(page.getPageNumber() * page.getPageSize(), set.size());
        int i = 0;
        for (Object t : set) {
            if (i >= endIndex) break;
            if (i < startIndex) {
                ++i;
                continue;
            }
            if (converter != null) {
                pageData.add(converter.convert(t));
            } else {
                pageData.add(t);
            }
            ++i;
        }
        page.setList(pageData);
        return page;
    }

    public static <T> Page<T> fromSetWithLock(SetWithLock<T> setWithLock, int pageNumber, int pageSize) {
        return PageUtils.fromSetWithLock(setWithLock, pageNumber, pageSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Page<T> fromSetWithLock(SetWithLock<?> setWithLock, int pageNumber, int pageSize, Converter<T> converter) {
        if (setWithLock == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock lock = setWithLock.readLock();
        lock.lock();
        try {
            Set set = (Set)setWithLock.getObj();
            Page<T> page = PageUtils.fromSet(set, pageNumber, pageSize, converter);
            return page;
        }
        finally {
            lock.unlock();
        }
    }

    private static Page<Object> pre(Collection<?> allList, int pageNumber, int pageSize) {
        if (allList == null) {
            return new Page<Object>(null, pageNumber, pageSize, 0);
        }
        pageSize = PageUtils.processPageSize(pageSize);
        pageNumber = PageUtils.processpageNumber(pageNumber);
        int recordCount = allList.size();
        if (pageSize > recordCount) {
            pageSize = recordCount;
        }
        ArrayList pageData = new ArrayList(pageSize);
        Page<Object> ret = new Page<Object>(pageData, pageNumber, pageSize, recordCount);
        return ret;
    }

    private static int processpageNumber(int pageNumber) {
        return pageNumber <= 0 ? 1 : pageNumber;
    }

    private static int processPageSize(int pageSize) {
        return pageSize <= 0 ? Integer.MAX_VALUE : pageSize;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("dd");
        list.add("dd");
        list.add("dd");
        list.add("dd");
        Page page = PageUtils.fromList(list, 1, 3);
        System.out.println(page);
        int i = 1;
        HashSet<String> set = new HashSet<String>();
        set.add("dd" + i++);
        set.add("dd" + i++);
        set.add("dd" + i++);
        set.add("dd" + i++);
        page = PageUtils.fromSet(set, 1, 3);
        System.out.println(page);
    }
}

