/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCopyCommand
extends SVNCommand {
    public SVNCopyCommand() {
        super("copy", new String[]{"cp"});
    }

    public boolean isCommitter() {
        return true;
    }

    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.PARENTS);
        options = SVNOption.addLogMessageOptions(options);
        return options;
    }

    public void run() throws SVNException {
        SVNPath dst;
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.size() < 2) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        if (!((dst = new SVNPath(targets.remove(targets.size() - 1))).isURL() || this.getSVNEnvironment().getMessage() == null && this.getSVNEnvironment().getFileData() == null && this.getSVNEnvironment().getRevisionProperties() == null)) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, (String)"Local, non-commit operations do not take a log message or revision properties"), (SVNLogType)SVNLogType.CLIENT);
        }
        ArrayList<SVNCopySource> sources = new ArrayList<SVNCopySource>();
        boolean sourceIsURL = false;
        for (int i = 0; i < targets.size(); ++i) {
            String targetName = targets.get(i);
            SVNPath source = new SVNPath(targetName, true);
            if (i == 0) {
                sourceIsURL = source.isURL();
            }
            if (source.isURL()) {
                sources.add(new SVNCopySource(source.getPegRevision(), this.getSVNEnvironment().getStartRevision(), source.getURL()));
                continue;
            }
            sources.add(new SVNCopySource(source.getPegRevision(), this.getSVNEnvironment().getStartRevision(), source.getFile()));
        }
        SVNCopyClient client = this.getSVNEnvironment().getClientManager().getCopyClient();
        if (!sourceIsURL && !dst.isURL()) {
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
        } else if (!sourceIsURL && dst.isURL()) {
            SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
            printer.setWcToReposCopy(true);
            client.setEventHandler((ISVNEventHandler)printer);
        } else if (sourceIsURL && !dst.isURL() && !this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment(), true, false, false));
        }
        client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
        SVNCopySource[] copySources = sources.toArray(new SVNCopySource[sources.size()]);
        if (dst.isURL()) {
            SVNCommitInfo info = client.doCopy(copySources, dst.getURL(), false, this.getSVNEnvironment().isParents(), false, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties());
            if (!this.getSVNEnvironment().isQuiet()) {
                this.getSVNEnvironment().printCommitInfo(info);
            }
        } else {
            client.doCopy(copySources, dst.getFile(), false, this.getSVNEnvironment().isParents(), false);
        }
    }
}

