/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnInheritedProperties;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNPropListCommand
extends SVNPropertiesCommand {
    public SVNPropListCommand() {
        super("proplist", new String[]{"plist", "pl"});
    }

    @Override
    protected Collection<SVNOption> createSupportedOptions() {
        ArrayList<SVNOption> options = new ArrayList<SVNOption>();
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.SHOW_INHERITED_PROPS);
        options.add(SVNOption.XML);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() throws SVNException {
        List<Object> targets = new ArrayList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isRevprop()) {
            void var7_12;
            long rev;
            SVNWCClient wcClient = this.getSVNEnvironment().getClientManager().getWCClient();
            String target = this.checkRevPropTarget(this.getSVNEnvironment().getStartRevision(), targets);
            if (SVNCommandUtil.isURL(target)) {
                rev = wcClient.doGetRevisionProperty(SVNURL.parseURIEncoded((String)target), null, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            } else {
                File targetPath = new SVNPath(target).getFile();
                rev = wcClient.doGetRevisionProperty(targetPath, null, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            }
            Map revisionPropertiesMap = this.getRevisionProperties();
            List list = (List)revisionPropertiesMap.get(new Long(rev));
            if (list == null) {
                List list2 = Collections.EMPTY_LIST;
            }
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLHeader("properties");
                StringBuffer buffer = this.openXMLTag("revprops", 1, "rev", Long.toString(rev), null);
                for (SVNPropertyData property : var7_12) {
                    buffer = this.addXMLProp(property, false, buffer);
                }
                buffer = this.closeXMLTag("revprops", buffer);
                this.getSVNEnvironment().getOut().print(buffer);
                this.printXMLFooter("properties");
            } else {
                this.getSVNEnvironment().getOut().println("Unversioned properties on revision " + rev + ":");
                for (SVNPropertyData property : var7_12) {
                    this.getSVNEnvironment().getOut().print("  " + property.getName());
                    if (this.getSVNEnvironment().isVerbose()) {
                        this.getSVNEnvironment().getOut().print(" : ");
                        if (property.getValue().isString()) {
                            this.getSVNEnvironment().getOut().print(property.getValue().getString());
                        } else {
                            try {
                                this.getSVNEnvironment().getOut().write(property.getValue().getBytes());
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    this.getSVNEnvironment().getOut().println();
                }
            }
            this.clearCollectedProperties();
        } else {
            SVNErrorMessage err;
            SVNDepth depth;
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLHeader("properties");
            }
            if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            SVNErrorCode errorCode = null;
            for (String string : targets) {
                SVNPath target = new SVNPath(string, true);
                SVNRevision pegRevision = target.getPegRevision();
                try {
                    SvnOperationFactory of = client.getOperationsFactory();
                    SvnGetProperties pl = of.createGetProperties();
                    if (target.isURL()) {
                        pl.setSingleTarget(SvnTarget.fromURL((SVNURL)target.getURL(), (SVNRevision)pegRevision));
                    } else {
                        pl.setSingleTarget(SvnTarget.fromFile((File)target.getFile(), (SVNRevision)pegRevision));
                    }
                    pl.setDepth(depth);
                    pl.setRevision(this.getSVNEnvironment().getStartRevision());
                    pl.setApplicalbeChangelists(changeLists);
                    pl.setReceiver((ISvnObjectReceiver)new ISvnObjectReceiver<SVNProperties>(){

                        public void receive(SvnTarget target, SVNProperties props) throws SVNException {
                            for (String propertyName : props.nameSet()) {
                                String name = propertyName.toString();
                                SVNPropertyData propertyData = new SVNPropertyData(name, props.getSVNPropertyValue(name), (ISVNOptions)SVNPropListCommand.this.getSVNEnvironment().getOptions());
                                if (target.isURL()) {
                                    SVNPropListCommand.this.handleProperty(target.getURL(), propertyData);
                                    continue;
                                }
                                SVNPropListCommand.this.handleProperty(target.getFile(), propertyData);
                            }
                        }
                    });
                    if (this.getSVNEnvironment().isShowInheritedProps()) {
                        pl.setTargetInheritedPropertiesReceiver((ISvnObjectReceiver)new ISvnObjectReceiver<List<SvnInheritedProperties>>(){

                            public void receive(SvnTarget target, List<SvnInheritedProperties> propsList) throws SVNException {
                                if (SVNPropListCommand.this.getSVNEnvironment().isXML()) {
                                    SVNPropListCommand.this.printInhertiedPropertiesXML(target, propsList);
                                } else {
                                    SVNPropListCommand.this.printInhertiedProperties(target, propsList);
                                }
                            }
                        });
                    }
                    pl.run();
                }
                catch (SVNException e) {
                    SVNErrorMessage err2 = e.getErrorMessage();
                    if (err2.getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                        err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.NODE_UNKNOWN_KIND, (String)"Unknown node kind for ''{0}''", (Object)err2.getRelatedObjects()[0]);
                    }
                    this.getSVNEnvironment().handleWarning(err2, new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.ENTRY_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                    errorCode = e.getErrorMessage().getErrorCode();
                }
                if (!this.getSVNEnvironment().isXML()) {
                    this.printCollectedProperties(false);
                    this.printCollectedProperties(true);
                } else {
                    this.printCollectedPropertiesXML(false);
                    this.printCollectedPropertiesXML(true);
                }
                this.clearCollectedProperties();
            }
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLFooter("properties");
            }
            if (errorCode == SVNErrorCode.ENTRY_NOT_FOUND) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Could not display properties of all targets because some targets don't exist");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            } else if (errorCode == SVNErrorCode.UNVERSIONED_RESOURCE) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Could not display properties of all targets because some targets are not versioned");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        }
    }

    protected void printCollectedProperties(boolean isURL) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            if (!this.getSVNEnvironment().isQuiet()) {
                this.getSVNEnvironment().getOut().print("Properties on '");
                if (isURL) {
                    this.getSVNEnvironment().getOut().print(key);
                } else {
                    String path = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
                    this.getSVNEnvironment().getOut().print(path);
                }
                this.getSVNEnvironment().getOut().println("':");
            }
            this.printProplist(props);
        }
    }

    protected void printCollectedPropertiesXML(boolean isURL) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            String target = key.toString();
            if (!isURL) {
                target = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
            }
            StringBuffer buffer = this.openXMLTag("target", 1, "path", target, null);
            for (SVNPropertyData property : props) {
                buffer = this.addXMLProp(property, false, buffer);
            }
            buffer = this.closeXMLTag("target", buffer);
            this.getSVNEnvironment().getOut().print(buffer);
        }
    }

    private void printInhertiedPropertiesXML(SvnTarget target, List<SvnInheritedProperties> propsList) {
        for (SvnInheritedProperties props : propsList) {
            String name = props.getTarget().isURL() ? props.getTarget().getPathOrUrlString() : SVNFileUtil.getFilePath((File)props.getTarget().getFile());
            StringBuffer buffer = this.openXMLTag("target", 1, "path", name, null);
            this.printXMLPropHash(buffer, props.getProperties(), !this.getSVNEnvironment().isVerbose(), true);
            buffer = this.closeXMLTag("target", buffer);
            this.getSVNEnvironment().getOut().print(buffer);
        }
    }

    private void printInhertiedProperties(SvnTarget target, List<SvnInheritedProperties> propsList) {
        String name = target.isURL() ? target.getPathOrUrlString() : SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath(target.getFile()));
        for (SvnInheritedProperties props : propsList) {
            if (!this.getSVNEnvironment().isQuiet()) {
                this.getSVNEnvironment().getOut().println("Inherited properties on '" + name + "',");
                if (props.getTarget().isURL()) {
                    this.getSVNEnvironment().getOut().println("from '" + props.getTarget().getPathOrUrlString() + "':");
                } else {
                    String localPath = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath(props.getTarget().getFile()));
                    this.getSVNEnvironment().getOut().println("from '" + localPath + "':");
                }
            }
            List<SVNPropertyData> propdataList = this.getPropdataList(props.getProperties());
            this.printProplist(propdataList);
        }
    }

    private List<SVNPropertyData> getPropdataList(SVNProperties properties) {
        ArrayList<SVNPropertyData> propertyDataList = new ArrayList<SVNPropertyData>();
        for (String name : properties.nameSet()) {
            SVNPropertyData propertyData = new SVNPropertyData(name, properties.getSVNPropertyValue(name), (ISVNOptions)this.getSVNEnvironment().getOptions());
            propertyDataList.add(propertyData);
        }
        return propertyDataList;
    }
}

