/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateCommand
extends SVNCommand {
    public SVNUpdateCommand() {
        super("update", new String[]{"up"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.SET_DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.DIFF3_CMD);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.EDITOR_CMD);
        options.add(SVNOption.ACCEPT);
        options.add(SVNOption.PARENTS);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws SVNException {
        List<Object> targets = new LinkedList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        LinkedList<File> fileTargets = new LinkedList<File>();
        for (String string : targets) {
            SVNPath target = new SVNPath(string);
            fileTargets.add(target.getFile());
        }
        if (this.getSVNEnvironment().getChangelists() != null) {
            void var4_7;
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNDepth sVNDepth = this.getSVNEnvironment().getDepth();
            if (sVNDepth == SVNDepth.UNKNOWN) {
                SVNDepth sVNDepth2 = SVNDepth.INFINITY;
            }
            SVNChangelistClient changelistClient = this.getSVNEnvironment().getClientManager().getChangelistClient();
            final LinkedList targetPaths = new LinkedList();
            ISVNChangelistHandler handler = new ISVNChangelistHandler(){

                public void handle(File path, String changelistName) {
                    targetPaths.add(path.getAbsolutePath());
                }
            };
            changelistClient.doGetChangeListPaths(changeLists, fileTargets, (SVNDepth)var4_7, handler);
            targets = targetPaths;
        }
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        SVNNotifyPrinter sVNNotifyPrinter = new SVNNotifyPrinter(this.getSVNEnvironment());
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)sVNNotifyPrinter);
        }
        SVNDepth depth = this.getSVNEnvironment().getDepth();
        boolean depthIsSticky = false;
        if (this.getSVNEnvironment().getSetDepth() != SVNDepth.UNKNOWN) {
            depth = this.getSVNEnvironment().getSetDepth();
            depthIsSticky = true;
        }
        ArrayList<File> files = new ArrayList<File>(targets.size());
        for (String string : targets) {
            SVNPath target = new SVNPath(string);
            if (!target.isFile()) {
                this.getSVNEnvironment().getOut().println("Skipped '" + string + "'");
                continue;
            }
            files.add(target.getFile());
        }
        File[] filesArray = files.toArray(new File[files.size()]);
        long[] lArray = client.doUpdate(filesArray, this.getSVNEnvironment().getStartRevision(), depth, this.getSVNEnvironment().isForce(), depthIsSticky, this.getSVNEnvironment().isParents());
        if (!this.getSVNEnvironment().isQuiet()) {
            StringBuffer status = new StringBuffer();
            this.printUpdateSummary(filesArray, lArray, status);
            sVNNotifyPrinter.printConflictStatus(status);
            this.getSVNEnvironment().getOut().print(status);
        }
        if (sVNNotifyPrinter.hasExternalErrors()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ERROR_PROCESSING_EXTERNALS, (String)"Failure occurred processing one or more externals definitions"), (SVNLogType)SVNLogType.CLIENT);
        }
    }

    private void printUpdateSummary(File[] targets, long[] results, StringBuffer status) {
        if (targets == null || targets.length < 2 || results == null || results.length < 2) {
            return;
        }
        status.append("Summary of updates:\n");
        for (int i = 0; i < targets.length; ++i) {
            long rev;
            long l = rev = i < results.length ? results[i] : -1L;
            if (rev < 0L) continue;
            status.append("  Updated '" + this.getSVNEnvironment().getRelativePath(targets[i]) + "' to r" + rev + ".\n");
        }
    }
}

