/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNGNUDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookDiffCommand
extends SVNLookCommand {
    public SVNLookDiffCommand() {
        super("diff", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.NO_DIFF_DELETED);
        options.add(SVNLookOption.NO_DIFF_ADDED);
        options.add(SVNLookOption.DIFF_COPY_FROM);
        options.add(SVNLookOption.EXTENSIONS);
        return options;
    }

    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        DefaultSVNGNUDiffGenerator defaultDiffGenerator = new DefaultSVNGNUDiffGenerator();
        defaultDiffGenerator.setOptions(client.getOptions());
        defaultDiffGenerator.setDiffOptions(environment.getDiffOptions());
        client.setDiffGenerator((ISVNGNUDiffGenerator)defaultDiffGenerator);
        if (environment.isRevision()) {
            client.doGetDiff(environment.getRepositoryFile(), this.getRevisionObject(), !environment.isNoDiffDeleted(), !environment.isNoDiffAdded(), environment.isDiffCopyFrom(), (OutputStream)environment.getOut());
        } else {
            client.doGetDiff(environment.getRepositoryFile(), environment.getTransaction(), !environment.isNoDiffDeleted(), !environment.isNoDiffAdded(), environment.isDiffCopyFrom(), (OutputStream)environment.getOut());
        }
    }
}

