/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.admin.ISVNTreeHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookTreeCommand
extends SVNLookCommand
implements ISVNTreeHandler {
    protected SVNLookTreeCommand() {
        super("tree", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.NON_RECURSIVE);
        options.add(SVNLookOption.SHOW_IDS);
        options.add(SVNLookOption.FULL_PATHS);
        return options;
    }

    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        String path = environment.getFirstArgument();
        if (environment.isRevision()) {
            client.doGetTree(environment.getRepositoryFile(), path, this.getRevisionObject(), environment.isShowIDs(), !environment.isNonRecursive(), (ISVNTreeHandler)this);
        } else {
            client.doGetTree(environment.getRepositoryFile(), path, environment.getTransaction(), environment.isShowIDs(), !environment.isNonRecursive(), (ISVNTreeHandler)this);
        }
    }

    public void handlePath(SVNAdminPath adminPath) throws SVNException {
        if (adminPath != null) {
            String indentation = null;
            if (!this.getSVNLookEnvironment().isFullPaths()) {
                indentation = "";
                for (int i = 0; i < adminPath.getTreeDepth(); ++i) {
                    indentation = indentation + " ";
                }
            }
            String path = adminPath.getPath();
            if (this.getSVNLookEnvironment().isFullPaths()) {
                String string = path = path.startsWith("/") && !"/".equals(path) ? path.substring(1) : path;
                if (adminPath.isDir() && !"/".equals(path) && !path.endsWith("/")) {
                    path = path + "/";
                }
                this.getSVNLookEnvironment().getOut().print(path);
            } else {
                String string = path = !"/".equals(path) ? SVNPathUtil.tail((String)path) : path;
                if (adminPath.isDir() && !"/".equals(path) && !path.endsWith("/")) {
                    path = path + "/";
                }
                this.getSVNLookEnvironment().getOut().print(indentation + path);
            }
            if (this.getSVNLookEnvironment().isShowIDs()) {
                String message = MessageFormat.format(" <{0}>", adminPath.getNodeID() != null ? adminPath.getNodeID() : "unknown");
                this.getSVNLookEnvironment().getOut().print(message);
            }
            this.getSVNLookEnvironment().getOut().println();
        }
    }
}

