/*
 * Decompiled with CFR 0.152.
 */
package ai.dify.javaclient;

import ai.dify.javaclient.DifyClientException;
import ai.dify.javaclient.DifyRequestException;
import ai.dify.javaclient.OkHttpUtil;
import ai.dify.javaclient.http.DifyRoute;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DifyClient {
    public static final DifyRoute APPLICATION = new DifyRoute("GET", "/parameters?user=%s");
    public static final DifyRoute FEEDBACK = new DifyRoute("POST", "/messages/%s/feedbacks");
    public static final DifyRoute CREATE_CHAT_MESSAGE = new DifyRoute("POST", "/chat-messages");
    public static final DifyRoute STOP_CHAT_MESSAGE = new DifyRoute("POST", "/chat-messages/%s/stop");
    public static final DifyRoute GET_CONVERSATION_MESSAGES = new DifyRoute("GET", "/messages?%s");
    public static final DifyRoute GET_SUGGESTED_MESSAGES = new DifyRoute("GET", "/messages/%s/suggested?user=%s");
    public static final DifyRoute GET_CONVERSATIONS = new DifyRoute("GET", "/conversations?%s");
    public static final DifyRoute RENAME_CONVERSATION = new DifyRoute("POST", "/conversations/%s/name");
    public static final DifyRoute DELETE_CONVERSATION = new DifyRoute("DELETE", "/conversations/%s");
    public static final DifyRoute GET_META = new DifyRoute("GET", "/meta?user=%s");
    private String apiKey;
    private final String baseUrl;
    private final OkHttpClient client;

    public DifyClient(String apiKey) {
        this(apiKey, "https://api.dify.ai/v1");
    }

    public DifyClient(String apiKey, String baseUrl) {
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.client = OkHttpUtil.getInstance();
    }

    public void updateApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Response sendRequest(DifyRoute route, String[] formatArgs, RequestBody body) throws DifyClientException {
        try {
            Request request = this.buildRequest(route, formatArgs, body, false);
            Response response = this.client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new DifyRequestException("Request failed with status: " + response.code());
            }
            return response;
        }
        catch (IOException e) {
            throw new DifyClientException("Error occurred while sending request: " + e.getMessage());
        }
    }

    public Request buildRequest(DifyRoute route, String[] formatArgs, RequestBody body, Boolean streaming) {
        String formattedURL = formatArgs != null && formatArgs.length > 0 ? String.format(route.url, formatArgs) : route.url;
        String contentType = "application/json";
        if (streaming.booleanValue()) {
            contentType = "text/event-stream";
        }
        Request request = new Request.Builder().url(this.baseUrl + formattedURL).method(route.method, body).addHeader("Authorization", "Bearer " + this.apiKey).addHeader("Content-Type", contentType).build();
        return request;
    }

    public Response messageFeedback(String messageId, String rating, String user) throws DifyClientException {
        JSONObject json = new JSONObject();
        json.put((Object)"rating", (Object)rating);
        json.put((Object)"user", (Object)user);
        return this.sendRequest(FEEDBACK, new String[]{messageId}, this.createJsonPayload(json));
    }

    public Response getApplicationParameters(String user) throws DifyClientException {
        return this.sendRequest(APPLICATION, new String[]{user}, null);
    }

    public Response getApplicationMeta(String user) throws DifyClientException {
        return this.sendRequest(GET_META, new String[]{user}, null);
    }

    RequestBody createJsonPayload(JSONObject jsonObject) {
        return RequestBody.create((String)jsonObject.toJSONString(new JSONWriter.Feature[0]), (MediaType)MediaType.parse((String)"application/json"));
    }
}

