/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client.http;

import com.alibaba.xxpt.gateway.shared.client.http.AbstractRequest;
import com.alibaba.xxpt.gateway.shared.client.http.GetClient;
import com.alibaba.xxpt.gateway.shared.client.http.GwException;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.alibaba.xxpt.gateway.shared.client.http.PostClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class ExecutableClient {
    private CloseableHttpClient httpClient;
    private IdleConnectionMonitorThread idleConnectionMonitorThread;
    private String uri;
    private String protocal;
    private String domainName;
    private String accessKey;
    private String secretKey;
    private long idletime = 30L;
    private int validateAfterInactivity = 60000;
    private Integer timeout;
    private HttpRoutePlanner routePlanner;
    private boolean inited = false;

    public static ExecutableClient getInstance() {
        return FactoryHodler.EXECUTABLE_CLIENT;
    }

    public ExecutableClient() {
    }

    public ExecutableClient(long idletime, boolean inited) {
        this.idletime = idletime;
        this.inited = inited;
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.uri = String.format("%s://%s", this.protocal, this.domainName);
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(800);
        cm.setDefaultMaxPerRoute(400);
        cm.setValidateAfterInactivity(this.validateAfterInactivity);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (null != this.getRoutePlanner()) {
            httpClientBuilder = httpClientBuilder.setRoutePlanner(this.getRoutePlanner());
        }
        this.httpClient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)cm).setConnectionManagerShared(true).build();
        this.idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)cm, this.idletime);
        this.idleConnectionMonitorThread.start();
        this.inited = true;
    }

    public String execute(AbstractRequest httpRequest) throws GwException {
        String response = null;
        int retry = 3;
        while (retry > 0) {
            try {
                if (StringUtils.isEmpty((CharSequence)httpRequest.getAccessKey()) || StringUtils.isEmpty((CharSequence)httpRequest.getSecretKey())) {
                    httpRequest.accessKey(this.accessKey).secretKey(this.secretKey);
                }
                response = (String)this.httpClient.execute(httpRequest.getHttpRequest(), (ResponseHandler)FactoryHodler.STRING_RESPONSE_HANDLER);
                break;
            }
            catch (NoHttpResponseException noHttpResponseException) {
                this.httpClient.getConnectionManager().closeExpiredConnections();
                this.httpClient.getConnectionManager().closeIdleConnections(this.idletime, TimeUnit.SECONDS);
                if (--retry != 0) continue;
                throw new GwException(noHttpResponseException.getMessage(), noHttpResponseException);
            }
            catch (IOException e) {
                throw new GwException(e.getMessage(), e);
            }
        }
        return response;
    }

    public CloseableHttpResponse executeB(AbstractRequest httpRequest) throws GwException {
        CloseableHttpResponse response;
        try {
            if (StringUtils.isEmpty((CharSequence)httpRequest.getAccessKey()) || StringUtils.isEmpty((CharSequence)httpRequest.getSecretKey())) {
                httpRequest.accessKey(this.accessKey).secretKey(this.secretKey);
            }
            response = this.httpClient.execute(httpRequest.getHttpRequest());
        }
        catch (IOException e) {
            throw new GwException(e.getMessage(), e);
        }
        return response;
    }

    public IntelligentGetClient newIntelligentGetClient(String api) {
        return this.newIntelligentGetClient(api, this.timeout == null ? 5000 : this.timeout);
    }

    public IntelligentGetClient newIntelligentGetClient(String api, int timeout) {
        return this.newIntelligentGetClient(api, "1.0", timeout);
    }

    public IntelligentGetClient newIntelligentGetClient(String api, String version) {
        return this.newIntelligentGetClient(api, version, this.timeout == null ? 5000 : this.timeout);
    }

    public IntelligentGetClient newIntelligentGetClient(String api, String version, int timeout) {
        return IntelligentGetClient.newInstance(this, this.uri, api, version, timeout);
    }

    public GetClient newGetClient(String api) {
        return this.newGetClient(api, this.timeout == null ? 5000 : this.timeout);
    }

    public GetClient newGetClient(String api, int timeout) {
        return this.newGetClient(api, "1.0", timeout);
    }

    public GetClient newGetClient(String api, String version) {
        return this.newGetClient(api, version, this.timeout == null ? 5000 : this.timeout);
    }

    public GetClient newGetClient(String api, String version, int timeout) {
        return GetClient.newInstance(this, this.uri, api, version, timeout);
    }

    public IntelligentPostClient newIntelligentPostClient(String api) {
        return this.newIntelligentPostClient(api, this.timeout == null ? 5000 : this.timeout);
    }

    public IntelligentPostClient newIntelligentPostClient(String api, int timeout) {
        return this.newIntelligentPostClient(api, "1.0", timeout);
    }

    public IntelligentPostClient newIntelligentPostClient(String api, String version) {
        return this.newIntelligentPostClient(api, version, this.timeout == null ? 5000 : this.timeout);
    }

    public IntelligentPostClient newIntelligentPostClient(String api, String version, int timeout) {
        return IntelligentPostClient.newInstance(this, this.uri, api, version, timeout);
    }

    public PostClient newPostClient(String api) {
        return this.newPostClient(api, this.timeout == null ? 5000 : this.timeout);
    }

    public PostClient newPostClient(String api, int timeout) {
        return this.newPostClient(api, "1.0", timeout);
    }

    public PostClient newPostClient(String api, String version) {
        return this.newPostClient(api, version, this.timeout == null ? 5000 : this.timeout);
    }

    public PostClient newPostClient(String api, String version, int timeout) {
        return PostClient.newInstance(this, this.uri, api, version, timeout);
    }

    public void destroy() {
        if (this.idleConnectionMonitorThread != null) {
            this.idleConnectionMonitorThread.shutdown();
            try {
                this.idleConnectionMonitorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setProtocal(String protocal) {
        this.protocal = protocal;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getUri() {
        return this.uri;
    }

    public long getIdletime() {
        return this.idletime;
    }

    public void setIdletime(long idletime) {
        this.idletime = idletime;
    }

    public HttpRoutePlanner getRoutePlanner() {
        return this.routePlanner;
    }

    public void setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(int validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    private static class FactoryHodler {
        public static final ExecutableClient EXECUTABLE_CLIENT = new ExecutableClient();
        public static final StringResponseHandler STRING_RESPONSE_HANDLER = new StringResponseHandler(Consts.UTF_8.name());
        public static final ByteResponseHandler BYTE_RESPONSE_HANDLER = new ByteResponseHandler();

        private FactoryHodler() {
        }
    }

    public static class ByteResponseHandler
    implements ResponseHandler<byte[]> {
        public byte[] handleResponse(HttpResponse response) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)bos);
            return bos.toByteArray();
        }
    }

    public static class StringResponseHandler
    implements ResponseHandler<String> {
        private String encode;

        public StringResponseHandler(String encode) {
            this.encode = encode;
        }

        public String handleResponse(HttpResponse response) throws IOException {
            String responseBody;
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            String string = responseBody = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (String)this.encode);
            if (statusLine.getStatusCode() >= 300 || statusLine.getStatusCode() == 203) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(statusLine.getStatusCode(), responseBody);
            }
            return responseBody;
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private final long idletime;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, long idletime) {
            this.connMgr = connMgr;
            this.idletime = idletime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(2000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(this.idletime, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

