/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client.http.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.client.http.AbstractRequest;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.alibaba.xxpt.gateway.shared.client.http.impl.GetRequest;
import com.alibaba.xxpt.gateway.shared.client.http.impl.PostRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequestAdapter {
    private static final Set<String> IGNORE_FIELD = new HashSet<String>();
    private static final Set<Class> SUPPORT_PARAM_CLASS = new HashSet<Class>();

    public static void adapter(AbstractRequest request, OapiRequest oapiRequest) {
        Map<String, List<String>> paramMap = RequestAdapter.parseOapiRequest(oapiRequest);
        if ("GET".equals(request.methodName())) {
            paramMap.forEach((key, value) -> value.forEach(v -> ((GetRequest)request).addParameter((String)key, (String)v)));
        } else if ("POST".equals(request.methodName())) {
            paramMap.forEach((key, value) -> value.forEach(v -> ((PostRequest)request).addParameter((String)key, (String)v)));
        } else {
            throw new RuntimeException("do not support method  " + request.methodName());
        }
    }

    private static Map<String, List<String>> parseOapiRequest(OapiRequest oapiRequest) {
        if (oapiRequest == null) {
            throw new NullPointerException("param " + OapiRequest.class.getName() + " cannot be null");
        }
        LinkedHashMap<String, List<String>> paramMap = new LinkedHashMap<String, List<String>>(16);
        JSONObject params = (JSONObject)JSON.toJSON((Object)oapiRequest);
        for (Map.Entry entry : params.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || IGNORE_FIELD.contains(entry.getKey())) continue;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ArrayList<String> valueList = new ArrayList<String>(16);
            if (value instanceof JSONArray) {
                for (Object v : (JSONArray)value) {
                    valueList.add(RequestAdapter.toStringValue(v));
                }
            } else {
                valueList.add(RequestAdapter.toStringValue(value));
            }
            if (valueList.isEmpty()) continue;
            paramMap.put(key, valueList);
        }
        return paramMap;
    }

    private static String toStringValue(Object v) {
        if (v == null) {
            return null;
        }
        if (!SUPPORT_PARAM_CLASS.contains(v.getClass())) {
            throw new RuntimeException("do not support param type " + v.getClass().getName());
        }
        return v.toString();
    }

    static {
        IGNORE_FIELD.add("responseClass");
        IGNORE_FIELD.add("apiUrl");
        SUPPORT_PARAM_CLASS.add(Byte.TYPE);
        SUPPORT_PARAM_CLASS.add(Short.TYPE);
        SUPPORT_PARAM_CLASS.add(Integer.TYPE);
        SUPPORT_PARAM_CLASS.add(Long.TYPE);
        SUPPORT_PARAM_CLASS.add(Double.TYPE);
        SUPPORT_PARAM_CLASS.add(Float.TYPE);
        SUPPORT_PARAM_CLASS.add(Boolean.TYPE);
        SUPPORT_PARAM_CLASS.add(Character.TYPE);
        SUPPORT_PARAM_CLASS.add(Byte.class);
        SUPPORT_PARAM_CLASS.add(Short.class);
        SUPPORT_PARAM_CLASS.add(Integer.class);
        SUPPORT_PARAM_CLASS.add(Long.class);
        SUPPORT_PARAM_CLASS.add(Double.class);
        SUPPORT_PARAM_CLASS.add(Float.class);
        SUPPORT_PARAM_CLASS.add(Boolean.class);
        SUPPORT_PARAM_CLASS.add(Character.class);
        SUPPORT_PARAM_CLASS.add(String.class);
    }
}

