/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openplatform;

import com.aliyun.common.Common;
import com.aliyun.openplatform.models.AuthorizeFileUploadRequest;
import com.aliyun.openplatform.models.AuthorizeFileUploadResponse;
import com.aliyun.openplatform.models.Config;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.Map;

public class Client {
    public String _endpoint;
    public String _regionId;
    public String _protocol;
    public String _userAgent;
    public Integer _readTimeout;
    public Integer _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _noProxy;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public Integer _maxIdleConns;
    public com.aliyun.credentials.Client _credential;

    public Client(Config config) throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        if (com.aliyun.teautil.Common.empty((String)config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.endpoint' can not be empty")}));
        }
        if (com.aliyun.teautil.Common.empty((String)config.regionId)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.regionId' can not be empty")}));
        }
        if (com.aliyun.teautil.Common.empty((String)config.type)) {
            config.type = "access_key";
        }
        com.aliyun.credentials.models.Config credentialConfig = com.aliyun.credentials.models.Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("accessKeyId", (Object)config.accessKeyId), new TeaPair("type", (Object)config.type), new TeaPair("accessKeySecret", (Object)config.accessKeySecret), new TeaPair("securityToken", (Object)config.securityToken)}));
        this._credential = new com.aliyun.credentials.Client(credentialConfig);
        this._endpoint = config.endpoint;
        this._protocol = config.protocol;
        this._regionId = config.regionId;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
    }

    public Map<String, Object> _request(String action, String protocol, String method, Map<String, Object> request, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.maxAttempts, (Number)2))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.backoffPeriod, (Number)0))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                String accessKeyId = this.getAccessKeyId();
                String accessKeySecret = this.getAccessKeySecret();
                request_.protocol = com.aliyun.teautil.Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = "/";
                request_.query = Common.query((Map)TeaConverter.merge(Object.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Action", (Object)action), new TeaPair("Format", (Object)"json"), new TeaPair("RegionId", (Object)this._regionId), new TeaPair("Timestamp", (Object)Common.getTimestamp()), new TeaPair("Version", (Object)"2019-12-19"), new TeaPair("SignatureMethod", (Object)"HMAC-SHA1"), new TeaPair("SignatureVersion", (Object)"1.0"), new TeaPair("SignatureNonce", (Object)com.aliyun.teautil.Common.getNonce()), new TeaPair("AccessKeyId", (Object)accessKeyId)}), request}));
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)Common.getHost((String)"OpenPlatform", (String)this._regionId, (String)this._endpoint)), new TeaPair("user-agent", (Object)this.getUserAgent())});
                request_.query.put("Signature", Common.getSignature((TeaRequest)request_, (String)accessKeySecret));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                Object obj = com.aliyun.teautil.Common.readAsJSON((InputStream)response_.body);
                Map body = com.aliyun.teautil.Common.assertAsMap((Object)obj);
                if (Common.hasError((Map)body)) {
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", body.get("Message")), new TeaPair("data", (Object)body), new TeaPair("code", body.get("Code"))}));
                }
                return body;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AuthorizeFileUploadResponse authorizeFileUpload(AuthorizeFileUploadRequest request, RuntimeOptions runtime) throws Exception {
        return (AuthorizeFileUploadResponse)TeaModel.toModel(this._request("AuthorizeFileUpload", "HTTPS", "GET", TeaModel.buildMap((TeaModel)request), runtime), (TeaModel)new AuthorizeFileUploadResponse());
    }

    public String getUserAgent() throws Exception {
        String userAgent = com.aliyun.teautil.Common.getUserAgent((String)this._userAgent);
        return userAgent;
    }

    public String getAccessKeyId() throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)this._credential)) {
            return "";
        }
        String accessKeyId = this._credential.getAccessKeyId();
        return accessKeyId;
    }

    public String getAccessKeySecret() throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)this._credential)) {
            return "";
        }
        String secret = this._credential.getAccessKeySecret();
        return secret;
    }
}

