/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.kms.model;

import java.io.Serializable;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * Container for the parameters to the {@link com.amazonaws.services.kms.AWSKMS#updateKeyDescription(UpdateKeyDescriptionRequest) UpdateKeyDescription operation}.
 * <p>
 * Updates the description of a key.
 * </p>
 *
 * @see com.amazonaws.services.kms.AWSKMS#updateKeyDescription(UpdateKeyDescriptionRequest)
 */
public class UpdateKeyDescriptionRequest extends AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * Unique value that identifies the key for which the description is to
     * be changed.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 256<br/>
     */
    private String keyId;

    /**
     * New description for the key.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>0 - 8192<br/>
     */
    private String description;

    /**
     * Unique value that identifies the key for which the description is to
     * be changed.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 256<br/>
     *
     * @return Unique value that identifies the key for which the description is to
     *         be changed.
     */
    public String getKeyId() {
        return keyId;
    }
    
    /**
     * Unique value that identifies the key for which the description is to
     * be changed.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 256<br/>
     *
     * @param keyId Unique value that identifies the key for which the description is to
     *         be changed.
     */
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }
    
    /**
     * Unique value that identifies the key for which the description is to
     * be changed.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 256<br/>
     *
     * @param keyId Unique value that identifies the key for which the description is to
     *         be changed.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public UpdateKeyDescriptionRequest withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * New description for the key.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>0 - 8192<br/>
     *
     * @return New description for the key.
     */
    public String getDescription() {
        return description;
    }
    
    /**
     * New description for the key.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>0 - 8192<br/>
     *
     * @param description New description for the key.
     */
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * New description for the key.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>0 - 8192<br/>
     *
     * @param description New description for the key.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public UpdateKeyDescriptionRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKeyId() != null) sb.append("KeyId: " + getKeyId() + ",");
        if (getDescription() != null) sb.append("Description: " + getDescription() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getKeyId() == null) ? 0 : getKeyId().hashCode()); 
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof UpdateKeyDescriptionRequest == false) return false;
        UpdateKeyDescriptionRequest other = (UpdateKeyDescriptionRequest)obj;
        
        if (other.getKeyId() == null ^ this.getKeyId() == null) return false;
        if (other.getKeyId() != null && other.getKeyId().equals(this.getKeyId()) == false) return false; 
        if (other.getDescription() == null ^ this.getDescription() == null) return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false) return false; 
        return true;
    }
    
    @Override
    public UpdateKeyDescriptionRequest clone() {
        
            return (UpdateKeyDescriptionRequest) super.clone();
    }

}
    