/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class StringHelperPOSIX
extends StringHelper {
    public static List<String> splitCommandLine(String commandLine) {
        String[] separators = new String[]{"&&", ";"};
        ArrayList commands = Lists.newArrayList();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        int commandStart = 0;
        block0: for (int i = 0; i < commandLine.length(); ++i) {
            char c = commandLine.charAt(i);
            if (escaping) {
                escaping = false;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (quoting) continue;
            for (String separator : separators) {
                if (!commandLine.substring(i).startsWith(separator)) continue;
                commands.add(commandLine.substring(commandStart, i));
                commandStart = i += separator.length();
                continue block0;
            }
        }
        if (commandStart < commandLine.length()) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static String quoteAndJoinTokens(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            token = token.replace("\\", "\\\\");
            token = token.replace("\"", "\\\"");
            sb.append("\"").append(token).append("\" ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<String> tokenizeString(String string) {
        ArrayList tokens = Lists.newArrayList();
        StringBuilder currentToken = new StringBuilder();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        for (char c : string.toCharArray()) {
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if (escaping) {
                escaping = false;
                if (c == '\n') continue;
                currentToken.append(c);
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                if (currentToken.length() > 0) {
                    tokens.add(currentToken.toString());
                }
                currentToken.setLength(0);
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }
}

