/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.redisson.Redisson;
import org.redisson.core.MessageListener;
import org.redisson.core.RTopic;

public class RedissonPubSubStore
implements PubSubStore {
    private final Redisson redissonPub;
    private final Redisson redissonSub;
    private final Long nodeId;
    private final ConcurrentMap<String, Queue<Integer>> map = PlatformDependent.newConcurrentHashMap();

    public RedissonPubSubStore(Redisson redissonPub, Redisson redissonSub, Long nodeId) {
        this.redissonPub = redissonPub;
        this.redissonSub = redissonSub;
        this.nodeId = nodeId;
    }

    @Override
    public void publish(String name, PubSubMessage msg) {
        msg.setNodeId(this.nodeId);
        this.redissonPub.getTopic(name).publish((Object)msg);
    }

    @Override
    public <T extends PubSubMessage> void subscribe(String name, final PubSubListener<T> listener, Class<T> clazz) {
        Queue oldList;
        RTopic topic = this.redissonSub.getTopic(name);
        int regId = topic.addListener(new MessageListener<T>(){

            public void onMessage(T msg) {
                if (!RedissonPubSubStore.this.nodeId.equals(((PubSubMessage)msg).getNodeId())) {
                    listener.onMessage(msg);
                }
            }
        });
        Queue<Integer> list = (ConcurrentLinkedQueue<Integer>)this.map.get(name);
        if (list == null && (oldList = (Queue)this.map.putIfAbsent(name, list = new ConcurrentLinkedQueue<Integer>())) != null) {
            list = oldList;
        }
        list.add(regId);
    }

    @Override
    public void unsubscribe(String name) {
        Queue regIds = (Queue)this.map.remove(name);
        RTopic topic = this.redissonSub.getTopic(name);
        for (Integer id : regIds) {
            topic.removeListener(id.intValue());
        }
    }

    @Override
    public void shutdown() {
    }
}

