/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg;

import monad.mmseg.Word;

public class Chunk {
    Word[] words = new Word[3];
    int count = -1;
    private int len = -1;
    private double avgLen = -1.0;
    private double variance = -1.0;
    private int sumDegree = -1;

    public int getLen() {
        if (this.len < 0) {
            this.len = 0;
            this.count = 0;
            for (Word word : this.words) {
                if (word == null) continue;
                this.len += word.getLength();
                ++this.count;
            }
        }
        return this.len;
    }

    public int getCount() {
        if (this.count < 0) {
            this.count = 0;
            for (Word word : this.words) {
                if (word == null) continue;
                ++this.count;
            }
        }
        return this.count;
    }

    public double getAvgLen() {
        if (this.avgLen < 0.0) {
            this.avgLen = (double)this.getLen() / (double)this.getCount();
        }
        return this.avgLen;
    }

    public double getVariance() {
        if (this.variance < 0.0) {
            double sum = 0.0;
            for (Word word : this.words) {
                if (word == null) continue;
                sum += Math.pow((double)word.getLength() - this.getAvgLen(), 2.0);
            }
            this.variance = sum / (double)this.getCount();
        }
        return this.variance;
    }

    public int getSumDegree() {
        if (this.sumDegree < 0) {
            int sum = 0;
            for (Word word : this.words) {
                if (word == null || word.getDegree() <= -1) continue;
                sum += word.getDegree();
            }
            this.sumDegree = sum;
        }
        return this.sumDegree;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Word word : this.words) {
            if (word == null) continue;
            sb.append(word.getString()).append('_');
        }
        return sb.toString();
    }

    public String toFactorString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("len=").append(this.getLen()).append(", ");
        sb.append("avgLen=").append(this.getAvgLen()).append(", ");
        sb.append("variance=").append(this.getVariance()).append(", ");
        sb.append("sum100log=").append(this.getSumDegree()).append("]");
        return sb.toString();
    }

    public Word[] getWords() {
        return this.words;
    }

    public void setWords(Word[] words) {
        this.words = words;
        this.count = words.length;
    }
}

