/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg;

import java.util.ArrayList;
import java.util.List;
import monad.mmseg.CharNode;
import monad.mmseg.Chunk;
import monad.mmseg.Dictionary;
import monad.mmseg.Seg;
import monad.mmseg.Sentence;
import monad.mmseg.Word;
import monad.mmseg.rule.LargestAvgLenRule;
import monad.mmseg.rule.LargestSumDegreeFreedomRule;
import monad.mmseg.rule.MaxMatchRule;
import monad.mmseg.rule.Rule;
import monad.mmseg.rule.SmallestVarianceRule;

public class ComplexSeg
extends Seg {
    private static boolean showChunk = false;
    private MaxMatchRule mmr = new MaxMatchRule();
    private List<Rule> otherRules = new ArrayList<Rule>();

    public ComplexSeg(Dictionary dic) {
        super(dic);
        this.otherRules.add(new LargestAvgLenRule());
        this.otherRules.add(new SmallestVarianceRule());
        this.otherRules.add(new LargestSumDegreeFreedomRule());
    }

    public static boolean isShowChunk() {
        return showChunk;
    }

    public static void setShowChunk(boolean showChunk) {
        ComplexSeg.showChunk = showChunk;
    }

    @Override
    public Chunk seg(Sentence sen) {
        char[] chs = sen.getText();
        int[] tailLen = new int[3];
        ArrayList[] tailLens = new ArrayList[2];
        for (int i = 0; i < 2; ++i) {
            tailLens[i] = new ArrayList();
        }
        CharNode[] cns = new CharNode[3];
        int[] offsets = new int[3];
        this.mmr.reset();
        if (!sen.isFinish()) {
            if (showChunk) {
                System.out.println();
            }
            int maxLen = 0;
            offsets[0] = sen.getOffset();
            this.maxMatch(cns, 0, chs, offsets[0], tailLens, 0);
            for (int aIdx = tailLens[0].size() - 1; aIdx >= 0; --aIdx) {
                tailLen[0] = (Integer)tailLens[0].get(aIdx);
                offsets[1] = offsets[0] + 1 + tailLen[0];
                this.maxMatch(cns, 1, chs, offsets[1], tailLens, 1);
                for (int bIdx = tailLens[1].size() - 1; bIdx >= 0; --bIdx) {
                    tailLen[1] = (Integer)tailLens[1].get(bIdx);
                    offsets[2] = offsets[1] + 1 + tailLen[1];
                    tailLen[2] = this.maxMatch(cns, 2, chs, offsets[2]);
                    int sumChunkLen = 0;
                    for (int i = 0; i < 3; ++i) {
                        sumChunkLen += tailLen[i] + 1;
                    }
                    Chunk ck = null;
                    if (sumChunkLen >= maxLen) {
                        maxLen = sumChunkLen;
                        ck = this.createChunk(sen, chs, tailLen, offsets, cns);
                        this.mmr.addChunk(ck);
                    }
                    if (!showChunk) continue;
                    if (ck == null) {
                        ck = this.createChunk(sen, chs, tailLen, offsets, cns);
                        this.mmr.addChunk(ck);
                    }
                    System.out.println(ck);
                }
            }
            sen.addOffset(maxLen);
            List<Chunk> chunks = this.mmr.remainChunks();
            for (Rule rule : this.otherRules) {
                if (showChunk) {
                    System.out.println("-------filter before " + rule + "----------");
                    this.printChunk(chunks);
                }
                if (chunks.size() <= 1) break;
                rule.reset();
                rule.addChunks(chunks);
                chunks = rule.remainChunks();
            }
            if (showChunk) {
                System.out.println("-------remainChunks----------");
                this.printChunk(chunks);
            }
            if (chunks.size() > 0) {
                return chunks.get(0);
            }
        }
        return null;
    }

    private Chunk createChunk(Sentence sen, char[] chs, int[] tailLen, int[] offsets, CharNode[] cns) {
        Chunk ck = new Chunk();
        for (int i = 0; i < 3; ++i) {
            CharNode cn;
            if (offsets[i] >= chs.length) continue;
            ck.words[i] = new Word(chs, sen.getStartOffset(), offsets[i], tailLen[i] + 1);
            if (tailLen[i] != 0 || (cn = cns[i]) == null) continue;
            ck.words[i].setDegree(cn.getFreq());
        }
        return ck;
    }
}

