/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;
import monad.mmseg.Chunk;
import monad.mmseg.Seg;
import monad.mmseg.Sentence;
import monad.mmseg.Word;

public class MMSeg {
    private PushbackReader reader;
    private Seg seg;
    private StringBuilder bufSentence = new StringBuilder(256);
    private Sentence currentSentence;
    private Queue<Word> bufWord;
    private int readedIdx = 0;

    public MMSeg(Reader input, Seg seg) {
        this.seg = seg;
        this.reset(input);
    }

    private static char[] toChars(StringBuilder bufSentence) {
        char[] chs = new char[bufSentence.length()];
        bufSentence.getChars(0, bufSentence.length(), chs, 0);
        return chs;
    }

    private static int toAscii(int codePoint) {
        if (codePoint >= 65296 && codePoint <= 65305 || codePoint >= 65313 && codePoint <= 65338 || codePoint >= 65345 && codePoint <= 65370) {
            codePoint -= 65248;
        }
        return codePoint;
    }

    private static boolean isAsciiLetter(int codePoint) {
        return codePoint >= 65 && codePoint <= 90 || codePoint >= 97 && codePoint <= 122;
    }

    private static boolean isRussiaLetter(int codePoint) {
        return codePoint >= 1040 && codePoint <= 1103 || codePoint == 1025 || codePoint == 1105;
    }

    private static boolean isGreeceLetter(int codePoint) {
        return codePoint >= 913 && codePoint <= 937 || codePoint >= 945 && codePoint <= 969;
    }

    private static boolean isCJK(int type) {
        return type == 5;
    }

    private static boolean isDigit(int type) {
        return type == 9;
    }

    private static boolean isLetter(int type) {
        return type <= 4 && type >= 1;
    }

    public void reset(Reader input) {
        this.reader = new PushbackReader(new BufferedReader(input), 20);
        this.currentSentence = null;
        this.bufWord = new LinkedList<Word>();
        this.bufSentence.setLength(0);
        this.readedIdx = -1;
    }

    private int readNext() throws IOException {
        int d = this.reader.read();
        if (d > -1) {
            ++this.readedIdx;
            d = Character.toLowerCase(d);
        }
        return d;
    }

    private void pushBack(int data) throws IOException {
        --this.readedIdx;
        this.reader.unread(data);
    }

    public Word next() throws IOException {
        Word word = this.bufWord.poll();
        if (word == null) {
            this.bufSentence.setLength(0);
            int data = -1;
            boolean read = true;
            block12: while (read && (data = this.readNext()) != -1) {
                read = false;
                int type = Character.getType(data);
                String wordType = "word";
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        data = MMSeg.toAscii(data);
                        NationLetter nl = this.getNation(data);
                        if (nl == NationLetter.UNKNOW) {
                            read = true;
                            continue block12;
                        }
                        wordType = "letter";
                        this.bufSentence.appendCodePoint(data);
                        switch (nl) {
                            case EN: {
                                ReadCharByAsciiOrDigit rcad = new ReadCharByAsciiOrDigit();
                                this.readChars(this.bufSentence, rcad);
                                if (!rcad.hasDigit()) break;
                                wordType = "letter_or_digit";
                                break;
                            }
                            case RA: {
                                this.readChars(this.bufSentence, new ReadCharByRussia());
                                break;
                            }
                            case GE: {
                                this.readChars(this.bufSentence, new ReadCharByGreece());
                            }
                        }
                        this.bufWord.add(this.createWord(this.bufSentence, wordType));
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 5: {
                        this.bufSentence.appendCodePoint(data);
                        this.readChars(this.bufSentence, new ReadCharByType(5));
                        this.currentSentence = this.createSentence(this.bufSentence);
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 9: {
                        this.bufSentence.appendCodePoint(MMSeg.toAscii(data));
                        this.readChars(this.bufSentence, new ReadCharDigit());
                        wordType = "digit";
                        int d = this.readNext();
                        if (d > -1) {
                            if (this.seg.isUnit(d)) {
                                this.bufWord.add(this.createWord(this.bufSentence, this.startIdx(this.bufSentence) - 1, "digit"));
                                this.bufSentence.setLength(0);
                                this.bufSentence.appendCodePoint(d);
                                wordType = "word";
                            } else {
                                this.pushBack(d);
                                if (this.readChars(this.bufSentence, new ReadCharByAsciiOrDigit()) > 0) {
                                    wordType = "digit_or_letter";
                                }
                            }
                        }
                        this.bufWord.add(this.createWord(this.bufSentence, wordType));
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 10: {
                        this.bufSentence.appendCodePoint(data);
                        this.readChars(this.bufSentence, new ReadCharByType(10));
                        int startIdx = this.startIdx(this.bufSentence);
                        for (int i = 0; i < this.bufSentence.length(); ++i) {
                            this.bufWord.add(new Word(new char[]{this.bufSentence.charAt(i)}, startIdx++, "letter_number"));
                        }
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 11: {
                        this.bufSentence.appendCodePoint(data);
                        this.readChars(this.bufSentence, new ReadCharByType(11));
                        this.bufWord.add(this.createWord(this.bufSentence, "other_number"));
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                }
                read = true;
            }
            if (this.currentSentence != null) {
                do {
                    Chunk chunk = this.seg.seg(this.currentSentence);
                    for (int i = 0; i < chunk.getCount(); ++i) {
                        this.bufWord.add(chunk.getWords()[i]);
                    }
                } while (!this.currentSentence.isFinish());
                this.currentSentence = null;
            }
            word = this.bufWord.poll();
        }
        return word;
    }

    private int readChars(StringBuilder bufSentence, ReadChar readChar) throws IOException {
        int num = 0;
        int data = -1;
        while ((data = this.readNext()) != -1) {
            int d = readChar.transform(data);
            if (readChar.isRead(d)) {
                bufSentence.appendCodePoint(d);
                ++num;
                continue;
            }
            this.pushBack(data);
            break;
        }
        return num;
    }

    private Word createWord(StringBuilder bufSentence, String type) {
        return new Word(MMSeg.toChars(bufSentence), this.startIdx(bufSentence), type);
    }

    private Word createWord(StringBuilder bufSentence, int startIdx, String type) {
        return new Word(MMSeg.toChars(bufSentence), startIdx, type);
    }

    private Sentence createSentence(StringBuilder bufSentence) {
        return new Sentence(MMSeg.toChars(bufSentence), this.startIdx(bufSentence));
    }

    private int startIdx(StringBuilder bufSentence) {
        return this.readedIdx - bufSentence.length() + 1;
    }

    private NationLetter getNation(int codePoint) {
        if (MMSeg.isAsciiLetter(codePoint)) {
            return NationLetter.EN;
        }
        if (MMSeg.isRussiaLetter(codePoint)) {
            return NationLetter.RA;
        }
        if (MMSeg.isGreeceLetter(codePoint)) {
            return NationLetter.GE;
        }
        return NationLetter.UNKNOW;
    }

    private static class ReadCharByType
    extends ReadChar {
        int charType;

        public ReadCharByType(int charType) {
            this.charType = charType;
        }

        @Override
        boolean isRead(int codePoint) {
            int type = Character.getType(codePoint);
            return type == this.charType;
        }
    }

    private static class ReadCharByGreece
    extends ReadCharDigit {
        private ReadCharByGreece() {
        }

        @Override
        boolean isRead(int codePoint) {
            return MMSeg.isGreeceLetter(codePoint);
        }
    }

    private static class ReadCharByRussia
    extends ReadCharDigit {
        private ReadCharByRussia() {
        }

        @Override
        boolean isRead(int codePoint) {
            return MMSeg.isRussiaLetter(codePoint);
        }
    }

    private static class ReadCharByAscii
    extends ReadCharDigit {
        private ReadCharByAscii() {
        }

        @Override
        boolean isRead(int codePoint) {
            return MMSeg.isAsciiLetter(codePoint);
        }
    }

    private static class ReadCharByAsciiOrDigit
    extends ReadCharDigit {
        private boolean hasDigit = false;

        private ReadCharByAsciiOrDigit() {
        }

        @Override
        boolean isRead(int codePoint) {
            boolean isRead = super.isRead(codePoint);
            this.hasDigit |= isRead;
            return MMSeg.isAsciiLetter(codePoint) || isRead;
        }

        boolean hasDigit() {
            return this.hasDigit;
        }
    }

    private static class ReadCharDigit
    extends ReadChar {
        private ReadCharDigit() {
        }

        @Override
        boolean isRead(int codePoint) {
            int type = Character.getType(codePoint);
            return MMSeg.isDigit(type);
        }

        @Override
        int transform(int codePoint) {
            return MMSeg.toAscii(codePoint);
        }
    }

    private static abstract class ReadChar {
        private ReadChar() {
        }

        abstract boolean isRead(int var1);

        int transform(int codePoint) {
            return codePoint;
        }
    }

    private static enum NationLetter {
        EN,
        RA,
        GE,
        UNKNOW;

    }
}

