/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg.rule;

import monad.mmseg.Chunk;
import monad.mmseg.rule.Rule;

public class LargestAvgLenRule
extends Rule {
    private double largestAvgLen;

    @Override
    public void addChunk(Chunk chunk) {
        if (chunk.getAvgLen() >= this.largestAvgLen) {
            this.largestAvgLen = chunk.getAvgLen();
            super.addChunk(chunk);
        }
    }

    @Override
    protected boolean isRemove(Chunk chunk) {
        return chunk.getAvgLen() < this.largestAvgLen;
    }

    @Override
    public void reset() {
        this.largestAvgLen = 0.0;
        super.reset();
    }
}

