/*
 * Decompiled with CFR 0.152.
 */
package monad.mmseg.rule;

import monad.mmseg.Chunk;
import monad.mmseg.rule.Rule;

public class SmallestVarianceRule
extends Rule {
    private double smallestVariance = Double.MAX_VALUE;

    @Override
    public void addChunk(Chunk chunk) {
        if (chunk.getVariance() <= this.smallestVariance) {
            this.smallestVariance = chunk.getVariance();
            super.addChunk(chunk);
        }
    }

    @Override
    public void reset() {
        this.smallestVariance = Double.MAX_VALUE;
        super.reset();
    }

    @Override
    protected boolean isRemove(Chunk chunk) {
        return chunk.getVariance() > this.smallestVariance;
    }
}

