/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.parser.deserializer.FileContainerDeserializer;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.resource.ContentResource;
import com.google.common.base.MoreObjects;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(using=FileContainerDeserializer.class)
public final class FileContainer
extends TextContainer {
    private TextContainer name;
    private Charset charset;
    private TextContainer content;

    private FileContainer(TextContainer container) {
        this.name = container;
        this.content = container;
    }

    public TextContainer getName() {
        return this.name;
    }

    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.charset);
    }

    @Override
    public ContentResource asResource() {
        if (this.content == null) {
            return null;
        }
        return this.content.asResource();
    }

    @Override
    public ContentResource asTemplateResource() {
        if (this.content == null) {
            return null;
        }
        return this.content.asTemplateResource();
    }

    @Override
    public ContentResource asTemplateResource(String resourceName) {
        if (this.content == null) {
            return null;
        }
        return this.content.asTemplateResource(resourceName);
    }

    @Override
    public boolean isRawText() {
        return this.content != null && this.content.isRawText();
    }

    @Override
    public String getText() {
        if (this.content == null) {
            return null;
        }
        return this.content.getText();
    }

    @Override
    public String getOperation() {
        if (this.content == null) {
            return null;
        }
        return this.content.getOperation();
    }

    @Override
    public boolean hasProperties() {
        return this.content != null && this.content.hasProperties();
    }

    @Override
    public Map<String, TextContainer> getProps() {
        if (this.content == null) {
            return null;
        }
        return this.content.getProps();
    }

    @Override
    public boolean isForTemplate() {
        return this.content != null && this.content.isForTemplate();
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("name", (Object)this.name).add("charset", (Object)this.charset);
    }

    @Override
    public boolean isFileContainer() {
        return true;
    }

    public static FileContainer asFileContainer(TextContainer container) {
        return new FileContainer(container);
    }

    public static FileContainerBuilder aFileContainer() {
        return new FileContainerBuilder();
    }

    public static final class FileContainerBuilder {
        private TextContainer name;
        private String charset;

        public FileContainerBuilder withName(TextContainer name) {
            this.name = name;
            return this;
        }

        public FileContainerBuilder withCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public FileContainer build() {
            FileContainer container = new FileContainer(this.name);
            container.charset = this.toCharset(this.charset).orElse(null);
            if (this.charset == null) {
                container.content = null;
            }
            return container;
        }

        private Optional<Charset> toCharset(String charset) {
            if (charset == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(Charset.forName(charset));
            }
            catch (UnsupportedCharsetException e) {
                return Optional.empty();
            }
        }
    }
}

