/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.parser.deserializer.LatencyContainerDeserializer;
import com.github.dreamhead.moco.procedure.LatencyProcedure;
import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;

@JsonDeserialize(using=LatencyContainerDeserializer.class)
public final class LatencyContainer {
    private long latency;
    private TimeUnit unit = TimeUnit.MILLISECONDS;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("latency", this.latency).add("unit", (Object)this.unit).toString();
    }

    public long getLatency() {
        return this.latency;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public static LatencyContainer latency(long latency) {
        return LatencyContainer.latencyWithUnit(latency, TimeUnit.MILLISECONDS);
    }

    public static LatencyContainer latencyWithUnit(long latency, TimeUnit timeUnit) {
        LatencyContainer latencyContainer = new LatencyContainer();
        latencyContainer.latency = latency;
        latencyContainer.unit = timeUnit;
        return latencyContainer;
    }

    public LatencyProcedure asProcedure() {
        return Moco.latency((long)this.latency, (TimeUnit)this.unit);
    }
}

