/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner;

import com.github.dreamhead.moco.bootstrap.arg.StartArgs;
import com.github.dreamhead.moco.runner.FileRunner;
import com.github.dreamhead.moco.runner.Runner;
import com.github.dreamhead.moco.runner.SettingRunner;
import com.github.dreamhead.moco.runner.ShutdownRunner;
import com.github.dreamhead.moco.runner.WatcherRunner;
import com.github.dreamhead.moco.runner.watcher.ShutdownMocoRunnerWatcher;
import com.github.dreamhead.moco.runner.watcher.Watcher;
import com.github.dreamhead.moco.runner.watcher.WatcherFactory;
import com.github.dreamhead.moco.util.Globs;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.stream.Collectors;

public final class RunnerFactory {
    private final WatcherFactory factory = new WatcherFactory();
    private final String shutdownKey;

    public RunnerFactory(String shutdownKey) {
        this.shutdownKey = shutdownKey;
    }

    public ShutdownRunner createRunner(StartArgs startArgs) {
        Runner dynamicRunner = this.createDynamicRunner(startArgs);
        ShutdownMocoRunnerWatcher watcher = this.factory.createShutdownWatcher(dynamicRunner, startArgs.getShutdownPort().orElse(0), this.shutdownKey);
        return new ShutdownRunner(dynamicRunner, watcher);
    }

    private Runner createDynamicRunner(StartArgs startArgs) {
        if (startArgs.hasConfigurationFile()) {
            return this.createDynamicConfigurationRunner(startArgs);
        }
        return this.createDynamicSettingRunner(startArgs);
    }

    private Runner createDynamicSettingRunner(StartArgs startArgs) {
        File settingsFile = new File(startArgs.getSettings().get());
        FileRunner fileRunner = FileRunner.createSettingFileRunner(settingsFile, startArgs);
        SettingRunner runner = (SettingRunner)fileRunner.getRunner();
        Watcher watcher = this.factory.createSettingWatcher(settingsFile, runner.getFiles(), fileRunner);
        return new WatcherRunner(fileRunner, watcher);
    }

    private Runner createDynamicConfigurationRunner(StartArgs startArgs) {
        String pathname = startArgs.getConfigurationFile().get();
        ImmutableList glob = Globs.glob((String)pathname);
        Iterable files = glob.stream().map(File::new).collect(Collectors.toList());
        FileRunner fileRunner = FileRunner.createConfigurationFileRunner(files, startArgs);
        Watcher watcher = this.factory.createConfigurationWatcher(files, fileRunner);
        return new WatcherRunner(fileRunner, watcher);
    }
}

