/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public final class MapConfigValidator {
    private static final ILogger LOGGER = Logger.getLogger(MapConfig.class);

    private MapConfigValidator() {
    }

    public static void checkNotNative(InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.NATIVE == inMemoryFormat) {
            throw new IllegalArgumentException("NATIVE storage format is supported in Hazelcast Enterprise only. Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
    }

    public static void checkMapConfig(MapConfig mapConfig) {
        MapConfigValidator.checkNotNative(mapConfig.getInMemoryFormat());
        MapConfigValidator.logIgnoredConfig(mapConfig);
    }

    private static void logIgnoredConfig(MapConfig mapConfig) {
        if (100L != mapConfig.getMinEvictionCheckMillis() || 25 != mapConfig.getEvictionPercentage()) {
            LOGGER.warning("As of version 3.7, `minEvictionCheckMillis` and `evictionPercentage` are deprecated due to the eviction mechanism change. New eviction mechanism uses a probabilistic algorithm based on sampling. Please see documentation for further details");
        }
    }
}

