/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Collect
extends Transform {
    private final MethodType source;
    private int index;
    private final Class arrayType;

    public Collect(MethodType source, int index, Class arrayType) {
        this.source = source;
        this.index = index;
        this.arrayType = arrayType;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return target.asCollector(this.arrayType, this.source.parameterCount() - this.index);
    }

    @Override
    public MethodType down(MethodType type) {
        this.assertTypesAreCompatible();
        return type.dropParameterTypes(this.index, this.source.parameterCount()).appendParameterTypes(this.arrayType);
    }

    private void assertTypesAreCompatible() {
        Class<?> componentType = this.arrayType.getComponentType();
        for (int i = this.index; i < this.source.parameterCount(); ++i) {
            TypeDescriptor.OfField in = this.source.parameterType(i);
            assert (((Class)in).isAssignableFrom(componentType)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
        }
    }

    @Override
    public String toString() {
        return "collect at " + this.index + " into " + this.arrayType.getName();
    }
}

