/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.ZoneAffinityServerListFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ServerListSubsetFilter<T extends Server>
extends ZoneAffinityServerListFilter<T>
implements IClientConfigAware,
Comparator<T> {
    private Random random = new Random();
    private volatile Set<T> currentSubset = Sets.newHashSet();
    private DynamicIntProperty sizeProp = new DynamicIntProperty("ribbon.ServerListSubsetFilter.size", 20);
    private DynamicFloatProperty eliminationPercent = new DynamicFloatProperty("ribbon.ServerListSubsetFilter.forceEliminatePercent", 0.1f);
    private DynamicIntProperty eliminationFailureCountThreshold = new DynamicIntProperty("ribbon.ServerListSubsetFilter.eliminationFailureThresold", 0);
    private DynamicIntProperty eliminationConnectionCountThreshold = new DynamicIntProperty("ribbon.ServerListSubsetFilter.eliminationConnectionThresold", 0);

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        this.sizeProp = new DynamicIntProperty(clientConfig.getClientName() + "." + clientConfig.getNameSpace() + ".ServerListSubsetFilter.size", 20);
        this.eliminationPercent = new DynamicFloatProperty(clientConfig.getClientName() + "." + clientConfig.getNameSpace() + ".ServerListSubsetFilter.forceEliminatePercent", 0.1f);
        this.eliminationFailureCountThreshold = new DynamicIntProperty(clientConfig.getClientName() + "." + clientConfig.getNameSpace() + ".ServerListSubsetFilter.eliminationFailureThresold", 0);
        this.eliminationConnectionCountThreshold = new DynamicIntProperty(clientConfig.getClientName() + "." + clientConfig.getNameSpace() + ".ServerListSubsetFilter.eliminationConnectionThresold", 0);
    }

    @Override
    public List<T> getFilteredListOfServers(List<T> servers) {
        List<T> zoneAffinityFiltered = super.getFilteredListOfServers(servers);
        HashSet candidates = Sets.newHashSet(zoneAffinityFiltered);
        HashSet newSubSet = Sets.newHashSet(this.currentSubset);
        LoadBalancerStats lbStats = this.getLoadBalancerStats();
        for (Server server : this.currentSubset) {
            if (!candidates.contains(server)) {
                newSubSet.remove(server);
                continue;
            }
            ServerStats stats = lbStats.getSingleServerStat(server);
            if (stats.getActiveRequestsCount() <= this.eliminationConnectionCountThreshold.get() && stats.getFailureCount() <= (long)this.eliminationFailureCountThreshold.get()) continue;
            newSubSet.remove(server);
            candidates.remove(server);
        }
        int targetedListSize = this.sizeProp.get();
        int numEliminated = this.currentSubset.size() - newSubSet.size();
        int minElimination = (int)((float)targetedListSize * this.eliminationPercent.get());
        int numToForceEliminate = 0;
        if (targetedListSize < newSubSet.size()) {
            numToForceEliminate = newSubSet.size() - targetedListSize;
        } else if (minElimination > numEliminated) {
            numToForceEliminate = minElimination - numEliminated;
        }
        if (numToForceEliminate > newSubSet.size()) {
            numToForceEliminate = newSubSet.size();
        }
        if (numToForceEliminate > 0) {
            ArrayList sortedSubSet = Lists.newArrayList((Iterable)newSubSet);
            Collections.sort(sortedSubSet, this);
            List forceEliminated = sortedSubSet.subList(0, numToForceEliminate);
            newSubSet.removeAll(forceEliminated);
            candidates.removeAll(forceEliminated);
        }
        if (newSubSet.size() < targetedListSize) {
            int numToChoose = targetedListSize - newSubSet.size();
            candidates.removeAll(newSubSet);
            if (numToChoose > candidates.size()) {
                candidates = Sets.newHashSet(zoneAffinityFiltered);
                candidates.removeAll(newSubSet);
            }
            List<T> chosen = this.randomChoose(Lists.newArrayList((Iterable)candidates), numToChoose);
            for (Server server : chosen) {
                newSubSet.add(server);
            }
        }
        this.currentSubset = newSubSet;
        return Lists.newArrayList((Iterable)newSubSet);
    }

    private List<T> randomChoose(List<T> servers, int toChoose) {
        int size = servers.size();
        if (toChoose >= size || toChoose < 0) {
            return servers;
        }
        for (int i = 0; i < toChoose; ++i) {
            int index = this.random.nextInt(size);
            Server tmp = (Server)servers.get(index);
            servers.set(index, servers.get(i));
            servers.set(i, tmp);
        }
        return servers.subList(0, toChoose);
    }

    @Override
    public int compare(T server1, T server2) {
        LoadBalancerStats lbStats = this.getLoadBalancerStats();
        ServerStats stats1 = lbStats.getSingleServerStat((Server)server1);
        ServerStats stats2 = lbStats.getSingleServerStat((Server)server2);
        int failuresDiff = (int)(stats2.getFailureCount() - stats1.getFailureCount());
        if (failuresDiff != 0) {
            return failuresDiff;
        }
        return stats2.getActiveRequestsCount() - stats1.getActiveRequestsCount();
    }
}

