/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Tagged
extends ASN1Object {
    private boolean explicit;
    private ASN1Object content;

    public ASN1Tagged(ASN1Identifier identifier, ASN1Object object) {
        this(identifier, object, true);
    }

    public ASN1Tagged(ASN1Identifier identifier, ASN1Object object, boolean explicit) {
        super(identifier);
        this.content = object;
        this.explicit = explicit;
        if (!explicit && this.content != null) {
            this.content.setIdentifier(identifier);
        }
    }

    public ASN1Tagged(ASN1Decoder dec, InputStream in, int len, ASN1Identifier identifier) throws IOException {
        super(identifier);
        this.content = new ASN1OctetString(dec, in, len);
    }

    public final void encode(ASN1Encoder enc, OutputStream out) throws IOException {
        enc.encode(this, out);
    }

    public final ASN1Object taggedValue() {
        return this.content;
    }

    public final void setTaggedValue(ASN1Object content) {
        this.content = content;
        if (!this.explicit && content != null) {
            content.setIdentifier(this.getIdentifier());
        }
    }

    public final boolean isExplicit() {
        return this.explicit;
    }

    public String toString() {
        if (this.explicit) {
            return super.toString() + this.content.toString();
        }
        return this.content.toString();
    }
}

