/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.DSETimeStamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ValueEventData
implements EventResponseData {
    private final String attribute;
    private final String classid;
    private final ASN1OctetString octData;
    private final String data;
    private final byte[] binData;
    private final String entry;
    private final String prepetratorDN;
    private final String syntax;
    private final DSETimeStamp timeStamp;
    private final int verb;

    public ValueEventData(ASN1Object message) throws IOException {
        byte[] bytedata = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(bytedata);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.prepetratorDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.entry = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.attribute = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.syntax = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.classid = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.timeStamp = new DSETimeStamp((ASN1Sequence)decode.decode(in, length));
        this.octData = (ASN1OctetString)decode.decode(in, length);
        this.data = this.octData.stringValue();
        this.binData = this.octData.byteValue();
        this.verb = ((ASN1Integer)decode.decode(in, length)).intValue();
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getClassid() {
        return this.classid;
    }

    public String getData() {
        return this.data;
    }

    public byte[] getBinaryData() {
        return this.binData;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getPrepetratorDN() {
        return this.prepetratorDN;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public DSETimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public int getVerb() {
        return this.verb;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ValueEventData");
        buf.append("(Attribute =" + this.getAttribute() + ")");
        buf.append("(Classid =" + this.getClassid() + ")");
        buf.append("(Data=" + this.getData() + ")");
        buf.append("(Entry =" + this.getEntry() + ")");
        buf.append("(Perpetrator =" + this.getPrepetratorDN() + ")");
        buf.append("(Syntax =" + this.getSyntax() + ")");
        buf.append("(TimeStamp =" + this.getTimeStamp() + ")");
        buf.append("(Verb =" + this.getVerb() + ")");
        buf.append("]");
        return buf.toString();
    }
}

