/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DirectiveList;
import com.novell.sasl.client.ParsedDirective;
import com.novell.security.sasl.SaslException;
import java.util.Iterator;

class ResponseAuth {
    private String m_responseValue = null;

    ResponseAuth(byte[] responseAuth) throws SaslException {
        DirectiveList dirList = new DirectiveList(responseAuth);
        try {
            dirList.parseDirectives();
            this.checkSemantics(dirList);
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    void checkSemantics(DirectiveList dirList) throws SaslException {
        Iterator directives = dirList.getIterator();
        while (directives.hasNext()) {
            ParsedDirective directive = (ParsedDirective)directives.next();
            String name = directive.getName();
            if (!name.equals("rspauth")) continue;
            this.m_responseValue = directive.getValue();
        }
        if (this.m_responseValue == null) {
            throw new SaslException("Missing response-auth directive.");
        }
    }

    public String getResponseValue() {
        return this.m_responseValue;
    }
}

