/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.jndi;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class JndiDSFactory
extends DSFactory {
    public static final String DS_NAME = "JNDI DataSource";
    private Setting setting;
    private Map<String, DataSource> dsMap = new ConcurrentHashMap<String, DataSource>();

    public JndiDSFactory() {
        this(null);
    }

    public JndiDSFactory(Setting setting) {
        super(DS_NAME, null, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        DataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
    }

    @Override
    public void destroy() {
    }

    private DataSource createDataSource(String group) {
        String jndiName;
        if (group == null) {
            group = "";
        }
        if (StrUtil.isEmpty(jndiName = this.setting.getByGroup("jndi", group))) {
            throw new DbRuntimeException("No setting name [jndi] for group [{}]", group);
        }
        DataSource ds = DbUtil.getJndiDs(jndiName);
        return ds;
    }
}

