/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.pooled;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.ds.pooled.DbConfig;
import com.xiaoleilu.hutool.setting.Setting;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        DbConfig config = new DbConfig();
        String jdbcUrl = this.setting.getByGroup("url", group);
        config.setDriver(this.setting.getStr("driver", group, DbUtil.identifyDriver(jdbcUrl)));
        config.setUrl(jdbcUrl);
        config.setUser(this.setting.getStr("user", group));
        config.setPass(this.setting.getStr("pass", group));
        config.setInitialSize(this.setting.getInt("initialSize", group, 0));
        config.setMinIdle(this.setting.getInt("minIdle", group, 0));
        config.setMaxActive(this.setting.getInt("maxActive", group, 8));
        config.setMaxWait(this.setting.getLong("maxWait", group, 6000L));
        return config;
    }
}

