/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.boon.cache.Cache;

public class FastReaderSingleThreadedCache<KEY, VALUE>
implements Cache<KEY, VALUE> {
    private final Map<KEY, VALUE> map = new HashMap<KEY, VALUE>();
    private final Deque<KEY> queue = new LinkedList<KEY>();
    private final int limit;

    public FastReaderSingleThreadedCache(int limit) {
        this.limit = limit;
    }

    @Override
    public void put(KEY key, VALUE value) {
        VALUE oldValue = this.map.put(key, value);
        if (oldValue != null) {
            this.queue.removeFirstOccurrence(key);
        }
        this.queue.addFirst(key);
        if (this.map.size() > this.limit) {
            KEY removedKey = this.queue.removeLast();
            this.map.remove(removedKey);
        }
    }

    @Override
    public VALUE get(KEY key) {
        this.queue.removeFirstOccurrence(key);
        this.queue.addFirst(key);
        return this.map.get(key);
    }

    @Override
    public VALUE getSilent(KEY key) {
        return this.map.get(key);
    }

    @Override
    public void remove(KEY key) {
        this.queue.removeFirstOccurrence(key);
        this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

