/*
 * Decompiled with CFR 0.152.
 */
package org.boon.logging;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.boon.core.Sys;
import org.boon.logging.ConfigurableLogger;
import org.boon.logging.InMemoryThreadLocalLogger;
import org.boon.logging.JDKLoggerFactory;
import org.boon.logging.LogLevel;
import org.boon.logging.LoggerDelegate;
import org.boon.logging.LoggerFactory;

public class Logging {
    private static final Context _context;
    private static WeakReference<Context> weakContext;
    public static final String LOGGER_FACTORY_CLASS_NAME = "org.boon.logger-logger-factory-class-name";

    private static Context context() {
        if (_context != null) {
            return _context;
        }
        Context context = (Context)weakContext.get();
        if (context == null) {
            context = new Context();
            weakContext = new WeakReference<Context>(context);
        }
        return context;
    }

    public static synchronized void init() {
        LoggerFactory factory;
        String className = JDKLoggerFactory.class.getName();
        try {
            className = System.getProperty(LOGGER_FACTORY_CLASS_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (className != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(className);
                factory = (LoggerFactory)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + className + "\"", e);
            }
        } else {
            factory = new JDKLoggerFactory();
        }
        Logging.context();
        Context.factory = factory;
    }

    public static ConfigurableLogger configurableLogger(Class<?> clazz) {
        return Logging.configurableLogger(clazz.getName());
    }

    public static ConfigurableLogger configurableLogger(String name) {
        Logging.context();
        ConfigurableLogger loggerDelegate = (ConfigurableLogger)Context.configurableLoggers.get(name);
        if (loggerDelegate == null) {
            loggerDelegate = new ConfigurableLogger(Logging.logger(name));
            Logging.context();
            ConfigurableLogger oldLoggerDelegate = Context.configurableLoggers.putIfAbsent(name, loggerDelegate);
            if (oldLoggerDelegate != null) {
                loggerDelegate = oldLoggerDelegate;
            }
        }
        return loggerDelegate;
    }

    public static LoggerDelegate logger(Class<?> clazz) {
        return Logging.logger(clazz.getName());
    }

    public static LoggerDelegate logger(String name) {
        Logging.context();
        LoggerDelegate loggerDelegate = (LoggerDelegate)Context.loggers.get(name);
        if (loggerDelegate == null) {
            Logging.context();
            loggerDelegate = Context.factory.logger(name);
            Logging.context();
            LoggerDelegate oldLoggerDelegate = Context.loggers.putIfAbsent(name, loggerDelegate);
            if (oldLoggerDelegate != null) {
                loggerDelegate = oldLoggerDelegate;
            }
        }
        return loggerDelegate;
    }

    public static void setLevel(String name, LogLevel level) {
        Logging.logger(name).level(level);
    }

    public static void turnOnInMemoryConfigLoggerAll(String name) {
        ConfigurableLogger configurableLogger = Logging.configurableLogger(name);
        configurableLogger.tee(new InMemoryThreadLocalLogger(LogLevel.ALL));
    }

    public static void turnOffInMemoryConfigLoggerAll(String name) {
        ConfigurableLogger configurableLogger = Logging.configurableLogger(name);
        configurableLogger.unwrap();
    }

    public static void removeLogger(String name) {
        Logging.context();
        Context.loggers.remove(name);
        Logging.context();
        Context.configurableLoggers.remove(name);
    }

    public static void removeLogger(Class<?> clazz) {
        Logging.context();
        Context.loggers.remove(clazz.getName());
        Logging.context();
        Context.configurableLoggers.remove(clazz.getName());
    }

    public static Object contextToHold() {
        return Logging.context();
    }

    static {
        weakContext = new WeakReference<Object>(null);
        boolean noStatics = Boolean.getBoolean("org.boon.noStatics");
        if (noStatics || Sys.inContainer()) {
            _context = null;
            weakContext = new WeakReference<Context>(new Context());
        } else {
            _context = new Context();
        }
        Logging.init();
    }

    private static class Context {
        private static volatile LoggerFactory factory;
        private static final ConcurrentMap<String, LoggerDelegate> loggers;
        private static final ConcurrentMap<String, ConfigurableLogger> configurableLoggers;

        private Context() {
        }

        static {
            loggers = new ConcurrentHashMap<String, LoggerDelegate>();
            configurableLoggers = new ConcurrentHashMap<String, ConfigurableLogger>();
        }
    }
}

