/*
 * Copyright 2016-2018 shardingsphere.io.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package io.shardingsphere.core.parsing.parser.sql.tcl.set.autocommit;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLSetAutoCommitParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerSetAutoCommitParser;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * Set auto commit parser factory.
 *
 * @author maxiaoguang
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class SetAutoCommitParserFactory {
    
    /**
     * Create set auto commit parser instance.
     *
     * @param dbType database type
     * @param lexerEngine lexical analysis engine.
     * @return set auto commit parser instance
     */
    public static AbstractSetAutoCommitParser newInstance(final DatabaseType dbType, final LexerEngine lexerEngine) {
        switch (dbType) {
            case H2:
            case MySQL:
                return new MySQLSetAutoCommitParser(lexerEngine);
            case SQLServer:
                return new SQLServerSetAutoCommitParser(lexerEngine);
            default:
                throw new UnsupportedOperationException(String.format("Cannot support database [%s].", dbType));
        }
    }
}
