/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.Tracing;
import brave.kafka.clients.KafkaTracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;

final class TracingConsumer<K, V>
implements Consumer<K, V> {
    final Consumer<K, V> delegate;
    final KafkaTracing kafkaTracing;
    final Tracing tracing;
    final TraceContext.Injector<Headers> injector;
    final String remoteServiceName;

    TracingConsumer(Consumer<K, V> delegate, KafkaTracing kafkaTracing) {
        this.delegate = delegate;
        this.kafkaTracing = kafkaTracing;
        this.tracing = kafkaTracing.tracing;
        this.injector = kafkaTracing.injector;
        this.remoteServiceName = kafkaTracing.remoteServiceName;
    }

    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.poll(timeout.toMillis());
    }

    public ConsumerRecords<K, V> poll(long timeout) {
        ConsumerRecords records = this.delegate.poll(timeout);
        if (records.isEmpty() || this.tracing.isNoop()) {
            return records;
        }
        long timestamp = 0L;
        LinkedHashMap<String, Span> consumerSpansForTopic = new LinkedHashMap<String, Span>();
        for (TopicPartition partition : records.partitions()) {
            String topic = partition.topic();
            List recordsInPartition = records.records(partition);
            int length = recordsInPartition.size();
            for (int i = 0; i < length; ++i) {
                Span span;
                ConsumerRecord record = (ConsumerRecord)recordsInPartition.get(i);
                TraceContextOrSamplingFlags extracted = this.kafkaTracing.extractAndClearHeaders(record.headers());
                if (extracted.samplingFlags() != null && extracted.extra().isEmpty()) {
                    span = (Span)consumerSpansForTopic.get(topic);
                    if (span == null) {
                        span = this.tracing.tracer().nextSpan(extracted);
                        if (!span.isNoop()) {
                            this.setConsumerSpan(topic, span);
                            if (timestamp == 0L) {
                                timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
                            }
                            span.start(timestamp);
                        }
                        consumerSpansForTopic.put(topic, span);
                    }
                    this.injector.inject(span.context(), (Object)record.headers());
                    continue;
                }
                span = this.tracing.tracer().nextSpan(extracted);
                if (!span.isNoop()) {
                    this.setConsumerSpan(topic, span);
                    if (timestamp == 0L) {
                        timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
                    }
                    span.start(timestamp).finish(timestamp);
                }
                this.injector.inject(span.context(), (Object)record.headers());
            }
        }
        for (Span span : consumerSpansForTopic.values()) {
            span.finish(timestamp);
        }
        return records;
    }

    public Set<TopicPartition> assignment() {
        return this.delegate.assignment();
    }

    public Set<String> subscription() {
        return this.delegate.subscription();
    }

    public void subscribe(Collection<String> topics) {
        this.delegate.subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(topics, callback);
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.delegate.assign(partitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(pattern, callback);
    }

    public void subscribe(Pattern pattern) {
        this.delegate.subscribe(pattern, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    public void commitSync() {
        this.delegate.commitSync();
    }

    public void commitSync(Duration timeout) {
        this.delegate.commitSync(timeout);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.delegate.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.delegate.commitSync(offsets, timeout);
    }

    public void commitAsync() {
        this.delegate.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.delegate.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.delegate.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.delegate.seek(partition, offset);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.delegate.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.delegate.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.delegate.position(partition);
    }

    public long position(TopicPartition partition, Duration timeout) {
        return this.delegate.position(partition, timeout);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.delegate.committed(partition);
    }

    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.delegate.committed(partition, timeout);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.delegate.partitionsFor(topic, timeout);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.delegate.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.delegate.listTopics(timeout);
    }

    public Set<TopicPartition> paused() {
        return this.delegate.paused();
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.delegate.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.delegate.resume(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.delegate.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.delegate.offsetsForTimes(timestampsToSearch, timeout);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.beginningOffsets(partitions, timeout);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.endOffsets(partitions, timeout);
    }

    public void close() {
        this.delegate.close();
    }

    public void close(long timeout, TimeUnit unit) {
        this.delegate.close(timeout, unit);
    }

    public void close(Duration timeout) {
        this.delegate.close(timeout);
    }

    public void wakeup() {
        this.delegate.wakeup();
    }

    void setConsumerSpan(String topic, Span span) {
        span.name("poll").kind(Span.Kind.CONSUMER).tag("kafka.topic", topic);
        if (this.remoteServiceName != null) {
            span.remoteServiceName(this.remoteServiceName);
        }
    }
}

