/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.config;

import com.google.common.collect.Maps;
import java.util.Map;
import net.parim.common.utils.PropertiesLoader;

public class Global {
    public static final String YES = "1";
    public static final String NO = "0";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static Map<String, String> map = Maps.newHashMap();
    private static PropertiesLoader loader = new PropertiesLoader("classpath*:/application.properties");

    private Global() {
    }

    public static String getConfig(String key) {
        String value = map.get(key);
        if (value == null) {
            value = loader.getProperty(key);
            map.put(key, value != null ? value : "");
        }
        return value;
    }

    public static String getUrlPrefix() {
        return Global.getConfig("web.view.prefix");
    }

    public static String getUrlSuffix() {
        return Global.getConfig("web.view.suffix");
    }

    public static String getTheme() {
        return Global.getConfig("site.theme");
    }

    public static String getThemeBasePath() {
        return Global.getConfig("site.theme.basePath");
    }

    public static String getThemePath() {
        return Global.getThemeBasePath() + Global.getTheme();
    }

    public static String getProjectPath() {
        return Global.getConfig("gen.projectPath");
    }

    public static void main(String[] args) {
        System.out.println(Global.getConfig("jdbc.username"));
        System.out.println(Global.getConfig("redis.password"));
    }
}

