/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.message;

import java.io.Serializable;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] messages;
    private Type type = Type.info;
    private String separator = ";";

    public Message(String ... messages) {
        this.messages = messages;
    }

    public Message(Type type, String ... messages) {
        this.type = type;
        this.messages = messages;
    }

    public Message(String separator, Type type, String ... messages) {
        this.type = type;
        this.separator = separator;
        this.messages = messages;
    }

    public String toString() {
        return this.concatMessage(this.messages);
    }

    private String concatMessage(String[] messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? this.separator : "");
        }
        return sb.toString();
    }

    public String[] getMessages() {
        return this.messages;
    }

    public void setMessages(String ... messages) {
        this.messages = messages;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public static enum Type {
        info,
        warning,
        error,
        success;

    }
}

