/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.parim.common.config.Global;
import net.parim.common.utils.CookieUtils;
import org.apache.commons.lang3.StringUtils;

public class Page<T> {
    private int pageNo = 1;
    private int pageSize = Integer.valueOf(Global.getConfig("page.pageSize"));
    private long count;
    private int first;
    private int last;
    private int prev;
    private int next;
    private boolean firstPage;
    private boolean lastPage;
    private int length = 8;
    private int slider = 1;
    private List<T> list = new ArrayList<T>();
    private String orderBy = "";
    private String funcName = "page";
    private String funcParam = "";
    private String message = "";

    public Page() {
        this.pageSize = -1;
    }

    public Page(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, -2);
    }

    public Page(HttpServletRequest request, HttpServletResponse response, int defaultPageSize) {
        String no = request.getParameter("pageNo");
        if (StringUtils.isNumeric((CharSequence)no)) {
            CookieUtils.setCookie(response, "pageNo", no);
            this.setPageNo(Integer.parseInt(no));
        } else if (request.getParameter("repage") != null && StringUtils.isNumeric((CharSequence)(no = CookieUtils.getCookie(request, "pageNo")))) {
            this.setPageNo(Integer.parseInt(no));
        }
        String size = request.getParameter("pageSize");
        if (StringUtils.isNumeric((CharSequence)size)) {
            CookieUtils.setCookie(response, "pageSize", size);
            this.setPageSize(Integer.parseInt(size));
        } else if (request.getParameter("repage") != null) {
            no = CookieUtils.getCookie(request, "pageSize");
            if (StringUtils.isNumeric((CharSequence)size)) {
                this.setPageSize(Integer.parseInt(size));
            }
        } else if (defaultPageSize != -2) {
            this.pageSize = defaultPageSize;
        }
        String orderBy = request.getParameter("orderBy");
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            this.setOrderBy(orderBy);
        }
    }

    public Page(int pageNo, int pageSize) {
        this(pageNo, pageSize, 0L);
    }

    public Page(int pageNo, int pageSize, long count) {
        this(pageNo, pageSize, count, new ArrayList());
    }

    public Page(int pageNo, int pageSize, long count, List<T> list) {
        this.setCount(count);
        this.setPageNo(pageNo);
        this.pageSize = pageSize;
        this.list = list;
    }

    public void initialize() {
        this.first = 1;
        this.last = (int)(this.count / (long)(this.pageSize < 1 ? 20 : this.pageSize) + (long)this.first - 1L);
        if (this.count % (long)this.pageSize != 0L || this.last == 0) {
            ++this.last;
        }
        if (this.last < this.first) {
            this.last = this.first;
        }
        if (this.pageNo <= 1) {
            this.pageNo = this.first;
            this.firstPage = true;
        }
        if (this.pageNo >= this.last) {
            this.pageNo = this.last;
            this.lastPage = true;
        }
        this.next = this.pageNo < this.last - 1 ? this.pageNo + 1 : this.last;
        this.prev = this.pageNo > 1 ? this.pageNo - 1 : this.first;
        if (this.pageNo < this.first) {
            this.pageNo = this.first;
        }
        if (this.pageNo > this.last) {
            this.pageNo = this.last;
        }
    }

    public String toString() {
        int i;
        int end;
        StringBuilder sb = new StringBuilder();
        if (this.pageNo == this.first) {
            sb.append("<li class=\"disabled\"><a href=\"javascript:\">&#171; \u4e0a\u4e00\u9875</a></li>\n");
        } else {
            sb.append("<li><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + this.prev + "," + this.pageSize + ",'" + this.funcParam + "');\">&#171; \u4e0a\u4e00\u9875</a></li>\n");
        }
        int begin = this.pageNo - this.length / 2;
        if (begin < this.first) {
            begin = this.first;
        }
        if ((end = begin + this.length - 1) >= this.last && (begin = (end = this.last) - this.length + 1) < this.first) {
            begin = this.first;
        }
        if (begin > this.first) {
            i = 0;
            for (i = this.first; i < this.first + this.slider && i < begin; ++i) {
                sb.append("<li><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + i + "," + this.pageSize + ",'" + this.funcParam + "');\">" + (i + 1 - this.first) + "</a></li>\n");
            }
            if (i < begin) {
                sb.append("<li class=\"disabled\"><a href=\"javascript:\">...</a></li>\n");
            }
        }
        for (i = begin; i <= end; ++i) {
            if (i == this.pageNo) {
                sb.append("<li class=\"active\"><a href=\"javascript:\">" + (i + 1 - this.first) + "</a></li>\n");
                continue;
            }
            sb.append("<li><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + i + "," + this.pageSize + ",'" + this.funcParam + "');\">" + (i + 1 - this.first) + "</a></li>\n");
        }
        if (this.last - end > this.slider) {
            sb.append("<li class=\"disabled\"><a href=\"javascript:\">...</a></li>\n");
            end = this.last - this.slider;
        }
        for (i = end + 1; i <= this.last; ++i) {
            sb.append("<li><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + i + "," + this.pageSize + ",'" + this.funcParam + "');\">" + (i + 1 - this.first) + "</a></li>\n");
        }
        if (this.pageNo == this.last) {
            sb.append("<li class=\"disabled\"><a href=\"javascript:\">\u4e0b\u4e00\u9875 &#187;</a></li>\n");
        } else {
            sb.append("<li><a href=\"javascript:\" onclick=\"" + this.funcName + "(" + this.next + "," + this.pageSize + ",'" + this.funcParam + "');\">" + "\u4e0b\u4e00\u9875 &#187;</a></li>\n");
        }
        sb.append("<li class=\"disabled controls\"><a href=\"javascript:\">\u5f53\u524d ");
        sb.append("<input type=\"text\" value=\"" + this.pageNo + "\" onkeypress=\"var e=window.event||this;var c=e.keyCode||e.which;if(c==13)");
        sb.append(this.funcName + "(this.value," + this.pageSize + ",'" + this.funcParam + "');\" onclick=\"this.select();\"/> / ");
        sb.append("<input type=\"text\" value=\"" + this.pageSize + "\" onkeypress=\"var e=window.event||this;var c=e.keyCode||e.which;if(c==13)");
        sb.append(this.funcName + "(" + this.pageNo + ",this.value,'" + this.funcParam + "');\" onclick=\"this.select();\"/> \u6761\uff0c");
        sb.append("\u5171 " + this.count + " \u6761" + (this.message != null ? this.message : "") + "</a></li>\n");
        sb.insert(0, "<ul>\n").append("</ul>\n");
        sb.append("<div style=\"clear:both;\"></div>");
        return sb.toString();
    }

    public String getHtml() {
        return this.toString();
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
        if ((long)this.pageSize >= count) {
            this.pageNo = 1;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 10 : pageSize;
    }

    @JsonIgnore
    public int getFirst() {
        return this.first;
    }

    @JsonIgnore
    public int getLast() {
        return this.last;
    }

    @JsonIgnore
    public int getTotalPage() {
        return this.getLast();
    }

    @JsonIgnore
    public boolean isFirstPage() {
        return this.firstPage;
    }

    @JsonIgnore
    public boolean isLastPage() {
        return this.lastPage;
    }

    @JsonIgnore
    public int getPrev() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    @JsonIgnore
    public int getNext() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    public List<T> getList() {
        return this.list;
    }

    public Page<T> setList(List<T> list) {
        this.list = list;
        this.initialize();
        return this;
    }

    @JsonIgnore
    public String getOrderBy() {
        String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";
        Pattern sqlPattern = Pattern.compile(reg, 2);
        if (sqlPattern.matcher(this.orderBy).find()) {
            return "";
        }
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @JsonIgnore
    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    @JsonIgnore
    public String getFuncParam() {
        return this.funcParam;
    }

    public void setFuncParam(String funcParam) {
        this.funcParam = funcParam;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public boolean isDisabled() {
        return this.pageSize == -1;
    }

    @JsonIgnore
    public boolean isNotCount() {
        return this.count == -1L;
    }

    public int getFirstResult() {
        int firstResult = (this.getPageNo() - 1) * this.getPageSize();
        if ((long)firstResult >= this.getCount()) {
            firstResult = 0;
        }
        return firstResult;
    }

    public int getMaxResults() {
        return this.getPageSize();
    }
}

