/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.security.shiro.session;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import net.parim.common.config.Global;
import net.parim.common.security.shiro.session.SessionDAO;
import net.parim.common.utils.DateUtils;
import net.parim.common.utils.StringUtils;
import net.parim.common.web.Servlets;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSessionDAO
extends EnterpriseCacheSessionDAO
implements SessionDAO {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void doUpdate(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        HttpServletRequest request = Servlets.getRequest();
        if (request != null) {
            String uri = request.getServletPath();
            if (Servlets.isStaticFile(uri)) {
                return;
            }
            if (StringUtils.startsWith((CharSequence)uri, (CharSequence)Global.getConfig("web.view.prefix")) && StringUtils.endsWith((CharSequence)uri, (CharSequence)Global.getConfig("web.view.suffix"))) {
                return;
            }
            String updateSession = request.getParameter("updateSession");
            if ("false".equals(updateSession) || "0".equals(updateSession)) {
                return;
            }
        }
        super.doUpdate(session);
        this.logger.debug("update {} {}", (Object)session.getId(), (Object)(request != null ? request.getRequestURI() : ""));
    }

    protected void doDelete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        super.doDelete(session);
        this.logger.debug("delete {} ", (Object)session.getId());
    }

    protected Serializable doCreate(Session session) {
        String uri;
        HttpServletRequest request = Servlets.getRequest();
        if (request != null && Servlets.isStaticFile(uri = request.getServletPath())) {
            return null;
        }
        super.doCreate(session);
        this.logger.debug("doCreate {} {}", (Object)session, (Object)(request != null ? request.getRequestURI() : ""));
        return session.getId();
    }

    protected Session doReadSession(Serializable sessionId) {
        return super.doReadSession(sessionId);
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        try {
            Session s = null;
            HttpServletRequest request = Servlets.getRequest();
            if (request != null) {
                String uri = request.getServletPath();
                if (Servlets.isStaticFile(uri)) {
                    return null;
                }
                s = (Session)request.getAttribute("session_" + sessionId);
            }
            if (s != null) {
                return s;
            }
            Session session = super.readSession(sessionId);
            this.logger.debug("readSession {} {}", (Object)sessionId, (Object)(request != null ? request.getRequestURI() : ""));
            if (request != null && session != null) {
                request.setAttribute("session_" + sessionId, (Object)session);
            }
            return session;
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave) {
        return this.getActiveSessions(includeLeave, null, null);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave, Object principal, Session filterSession) {
        if (includeLeave && principal == null) {
            return this.getActiveSessions();
        }
        HashSet sessions = Sets.newHashSet();
        for (Session session : this.getActiveSessions()) {
            boolean isActiveSession = false;
            if (includeLeave || DateUtils.pastMinutes(session.getLastAccessTime()) <= 3L) {
                isActiveSession = true;
            }
            if (principal != null) {
                PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                if (principal.toString().equals(pc != null ? pc.getPrimaryPrincipal().toString() : "")) {
                    isActiveSession = true;
                }
            }
            if (filterSession != null && filterSession.getId().equals(session.getId())) {
                isActiveSession = false;
            }
            if (!isActiveSession) continue;
            sessions.add(session);
        }
        return sessions;
    }
}

