/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.service;

import java.io.Serializable;
import java.util.List;
import net.parim.common.persistence.BaseEntity;
import net.parim.common.persistence.CrudRepository;
import net.parim.common.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class CrudService<R extends CrudRepository<T, ID>, T extends BaseEntity<?>, ID extends Serializable>
extends BaseService {
    @Autowired
    protected R repository;

    public T findOne(ID id) {
        return (T)this.repository.findOne(id);
    }

    public T findOne(T entity) {
        return this.repository.findOne(entity);
    }

    public List<T> findAll(T entity) {
        return this.repository.findAll(entity);
    }

    public Page<T> findAll(T entity, Pageable pageable) {
        return (Page)this.repository.findAll(entity, pageable);
    }

    @Transactional(readOnly=false)
    public void save(T entity) {
        if (((BaseEntity)entity).isNewRecord()) {
            this.repository.insert(entity);
        } else {
            this.repository.update(entity);
        }
    }

    @Transactional(readOnly=false)
    public void delete(T entity) {
        this.repository.delete(entity);
    }
}

