/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import net.parim.common.utils.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    private static Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static boolean copyFile(String srcFileName, String descFileName) {
        return FileUtils.copyFileCover(srcFileName, descFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileCover(String srcFileName, String descFileName, boolean coverlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            log.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 " + srcFileName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcFile.isFile()) {
            log.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c" + srcFileName + " \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6!");
            return false;
        }
        File descFile = new File(descFileName);
        if (descFile.exists()) {
            if (!coverlay) {
                log.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
                return false;
            }
            log.debug("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtils.delFile(descFileName)) {
                log.debug("\u5220\u9664\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5931\u8d25!");
                return false;
            }
        } else if (!descFile.getParentFile().exists()) {
            log.debug("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u76ee\u5f55!");
            if (!descFile.getParentFile().mkdirs()) {
                log.debug("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        int readByte = 0;
        FileInputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new FileInputStream(srcFile);
            outs = new FileOutputStream(descFile);
            byte[] buf = new byte[1024];
            while ((readByte = ((InputStream)ins).read(buf)) != -1) {
                outs.write(buf, 0, readByte);
            }
            log.debug("\u590d\u5236\u5355\u4e2a\u6587\u4ef6 " + srcFileName + " \u5230" + descFileName + "\u6210\u529f!");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (IOException oute) {
                    oute.printStackTrace();
                }
            }
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ine) {
                    ine.printStackTrace();
                }
            }
        }
    }

    public static boolean copyDirectory(String srcDirName, String descDirName) {
        return FileUtils.copyDirectoryCover(srcDirName, descDirName, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean copyDirectoryCover(String srcDirName, String descDirName, boolean coverlay) {
        File descDir;
        File srcDir = new File(srcDirName);
        if (!srcDir.exists()) {
            log.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c\u6e90\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcDir.isDirectory()) {
            log.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c" + srcDirName + " \u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55!");
            return false;
        }
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            if (!coverlay) {
                log.debug("\u76ee\u6807\u76ee\u5f55\u590d\u5236\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
                return false;
            }
            log.debug("\u76ee\u6807\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtils.delFile(descDirNames)) {
                log.debug("\u5220\u9664\u76ee\u5f55 " + descDirNames + " \u5931\u8d25!");
                return false;
            }
        } else {
            log.debug("\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa!");
            if (!descDir.mkdirs()) {
                log.debug("\u521b\u5efa\u76ee\u6807\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        boolean flag = true;
        File[] files = srcDir.listFiles();
        for (int i = 0; !(i >= files.length || files[i].isFile() && !(flag = FileUtils.copyFile(files[i].getAbsolutePath(), descDirName + files[i].getName())) || files[i].isDirectory() && !(flag = FileUtils.copyDirectory(files[i].getAbsolutePath(), descDirName + files[i].getName()))); ++i) {
        }
        if (!flag) {
            log.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u5931\u8d25!");
            return false;
        }
        log.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u6210\u529f!");
        return true;
    }

    public static boolean delFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            log.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
            return true;
        }
        if (file.isFile()) {
            return FileUtils.deleteFile(fileName);
        }
        return FileUtils.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                log.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u6210\u529f!");
                return true;
            }
            log.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u5931\u8d25!");
            return false;
        }
        log.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
        return true;
    }

    public static boolean deleteDirectory(String dirName) {
        File dirFile;
        String dirNames = dirName;
        if (!dirNames.endsWith(File.separator)) {
            dirNames = dirNames + File.separator;
        }
        if (!(dirFile = new File(dirNames)).exists() || !dirFile.isDirectory()) {
            log.debug(dirNames + " \u76ee\u5f55\u4e0d\u5b58\u5728!");
            return true;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtils.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = FileUtils.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            log.debug("\u5220\u9664\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        if (dirFile.delete()) {
            log.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u6210\u529f!");
            return true;
        }
        log.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u5931\u8d25!");
        return false;
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            log.debug("\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descFileName.endsWith(File.separator)) {
            log.debug(descFileName + " \u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55!");
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            log.debug("\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        try {
            if (file.createNewFile()) {
                log.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f!");
                return true;
            }
            log.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            log.debug("\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descDir.mkdirs()) {
            log.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u6210\u529f!");
            return true;
        }
        log.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u5931\u8d25!");
        return false;
    }

    public static void writeToFile(String fileName, String content, boolean append) {
        try {
            FileUtils.write((File)new File(fileName), (CharSequence)content, (String)"utf-8", (boolean)append);
            log.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            log.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    public static void writeToFile(String fileName, String content, String encoding, boolean append) {
        try {
            FileUtils.write((File)new File(fileName), (CharSequence)content, (String)encoding, (boolean)append);
            log.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            log.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    public static void zipFiles(String srcDirName, String fileName, String descFileName) {
        if (srcDirName == null) {
            log.debug("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff0c\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return;
        }
        File fileDir = new File(srcDirName);
        if (!fileDir.exists() || !fileDir.isDirectory()) {
            log.debug("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff0c\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return;
        }
        String dirPath = fileDir.getAbsolutePath();
        File descFile = new File(descFileName);
        try {
            ZipOutputStream zouts = new ZipOutputStream((OutputStream)new FileOutputStream(descFile));
            if ("*".equals(fileName) || "".equals(fileName)) {
                FileUtils.zipDirectoryToZipFile(dirPath, fileDir, zouts);
            } else {
                File file = new File(fileDir, fileName);
                if (file.isFile()) {
                    FileUtils.zipFilesToZipFile(dirPath, file, zouts);
                } else {
                    FileUtils.zipDirectoryToZipFile(dirPath, file, zouts);
                }
            }
            zouts.close();
            log.debug(descFileName + " \u6587\u4ef6\u538b\u7f29\u6210\u529f!");
        }
        catch (Exception e) {
            log.debug("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static boolean unZipFiles(String zipFileName, String descFileName) {
        String descFileNames = descFileName;
        if (!descFileNames.endsWith(File.separator)) {
            descFileNames = descFileNames + File.separator;
        }
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            ZipEntry entry = null;
            String entryName = null;
            String descFileDir = null;
            byte[] buf = new byte[4096];
            int readByte = 0;
            Enumeration enums = zipFile.getEntries();
            while (enums.hasMoreElements()) {
                entry = (ZipEntry)enums.nextElement();
                entryName = entry.getName();
                descFileDir = descFileNames + entryName;
                if (entry.isDirectory()) {
                    new File(descFileDir).mkdirs();
                    continue;
                }
                new File(descFileDir).getParentFile().mkdirs();
                File file = new File(descFileDir);
                FileOutputStream os = new FileOutputStream(file);
                InputStream is = zipFile.getInputStream(entry);
                while ((readByte = is.read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, readByte);
                }
                ((OutputStream)os).close();
                is.close();
            }
            zipFile.close();
            log.debug("\u6587\u4ef6\u89e3\u538b\u6210\u529f!");
            return true;
        }
        catch (Exception e) {
            log.debug("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
    }

    public static void zipDirectoryToZipFile(String dirPath, File fileDir, ZipOutputStream zouts) {
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            if (files.length == 0) {
                ZipEntry entry = new ZipEntry(FileUtils.getEntryName(dirPath, fileDir));
                try {
                    zouts.putNextEntry(entry);
                    zouts.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    FileUtils.zipFilesToZipFile(dirPath, files[i], zouts);
                    continue;
                }
                FileUtils.zipDirectoryToZipFile(dirPath, files[i], zouts);
            }
        }
    }

    public static void zipFilesToZipFile(String dirPath, File file, ZipOutputStream zouts) {
        FileInputStream fin = null;
        ZipEntry entry = null;
        byte[] buf = new byte[4096];
        int readByte = 0;
        if (file.isFile()) {
            try {
                fin = new FileInputStream(file);
                entry = new ZipEntry(FileUtils.getEntryName(dirPath, file));
                zouts.putNextEntry(entry);
                while ((readByte = fin.read(buf)) != -1) {
                    zouts.write(buf, 0, readByte);
                }
                zouts.closeEntry();
                fin.close();
                System.out.println("\u6dfb\u52a0\u6587\u4ef6 " + file.getAbsolutePath() + " \u5230zip\u6587\u4ef6\u4e2d!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getEntryName(String dirPath, File file) {
        String dirPaths = dirPath;
        if (!dirPaths.endsWith(File.separator)) {
            dirPaths = dirPaths + File.separator;
        }
        String filePath = file.getAbsolutePath();
        if (file.isDirectory()) {
            filePath = filePath + "/";
        }
        int index = filePath.indexOf(dirPaths);
        return filePath.substring(index + dirPaths.length());
    }

    public static String path(String path) {
        String p = StringUtils.replace((String)path, (String)"\\", (String)"/");
        if (!StringUtils.startsWithAny((CharSequence)(p = StringUtils.join((Object[])StringUtils.split((String)p, (String)"/"), (String)"/")), (CharSequence[])new CharSequence[]{"/"}) && StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"\\", "/"})) {
            p = p + "/";
        }
        if (!StringUtils.endsWithAny((CharSequence)p, (CharSequence[])new CharSequence[]{"/"}) && StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"\\", "/"})) {
            p = p + "/";
        }
        return p;
    }
}

