/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(JsonUtil.class);
    private static JsonUtil mapper;

    public JsonUtil() {
        this(JsonInclude.Include.NON_EMPTY);
    }

    public JsonUtil(JsonInclude.Include include) {
        if (include != null) {
            this.setSerializationInclusion(include);
        }
        this.enableSimple();
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString("");
            }
        });
        this.registerModule((Module)new SimpleModule().addSerializer(String.class, (JsonSerializer)new JsonSerializer<String>(){

            public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(StringEscapeUtils.unescapeHtml4((String)value));
            }
        }));
        this.setTimeZone(TimeZone.getDefault());
    }

    public static JsonUtil getInstance() {
        if (mapper == null) {
            mapper = new JsonUtil().enableSimple();
        }
        return mapper;
    }

    public static JsonUtil nonDefaultMapper() {
        if (mapper == null) {
            mapper = new JsonUtil(JsonInclude.Include.NON_DEFAULT);
        }
        return mapper;
    }

    public String toJson(Object object) {
        try {
            return this.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to json string error:" + object, (Throwable)e);
            return null;
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public <T> T fromJson(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public JavaType createCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return this.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public <T> T update(String jsonString, T object) {
        try {
            return (T)this.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        return null;
    }

    public String toJsonP(String functionName, Object object) {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public JsonUtil enableEnumUseToString() {
        this.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        return this;
    }

    public JsonUtil enableJaxbAnnotation() {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.registerModule((Module)module);
        return this;
    }

    public JsonUtil enableSimple() {
        this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        return this;
    }

    public ObjectMapper getMapper() {
        return this;
    }

    public static String toJsonString(Object object) {
        return JsonUtil.getInstance().toJson(object);
    }

    public static Object fromJsonString(String jsonString, Class<?> clazz) {
        return JsonUtil.getInstance().fromJson(jsonString, clazz);
    }

    public static void main(String[] args) {
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", 1);
        map.put("pId", -1);
        map.put("name", "\u6839\u8282\u70b9");
        list.add(map);
        map = new HashMap();
        map.put("id", 2);
        map.put("pId", 1);
        map.put("name", "\u4f60\u597d");
        map.put("open", true);
        list.add(map);
        String json = JsonUtil.getInstance().toJson(list);
    }
}

